/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.external.client.join;

import com.iohao.game.action.skeleton.core.BarSkeleton;
import com.iohao.game.action.skeleton.core.DataCodecKit;
import com.iohao.game.common.kit.log.IoGameLoggerFactory;
import com.iohao.game.external.client.ClientConnectOption;
import com.iohao.game.external.client.join.ClientConnect;
import com.iohao.game.external.client.user.ClientUser;
import com.iohao.game.external.client.user.ClientUserChannel;
import com.iohao.game.external.core.message.ExternalMessage;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.handshake.ServerHandshake;
import org.slf4j.Logger;

class WebSocketClientStartup
implements ClientConnect {
    static final Logger log = IoGameLoggerFactory.getLoggerCommonStdout();

    WebSocketClientStartup() {
    }

    @Override
    public void connect(ClientConnectOption option) {
        ClientUser clientUser = option.getClientUser();
        final ClientUserChannel clientUserChannel = clientUser.getClientUserChannel();
        String wsUrl = option.getWsUrl();
        final BarSkeleton barSkeleton = option.getBarSkeleton();
        URI uri = null;
        try {
            uri = new URI(wsUrl);
        }
        catch (URISyntaxException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        WebSocketClient webSocketClient = new WebSocketClient(Objects.requireNonNull(uri), (Draft)new Draft_6455()){

            public void onOpen(ServerHandshake handshakedata) {
            }

            public void onMessage(String s) {
            }

            public void onClose(int i, String s, boolean b) {
            }

            public void onError(Exception e) {
            }

            public void onMessage(ByteBuffer byteBuffer) {
                byte[] dataContent = byteBuffer.array();
                ExternalMessage externalMessage = (ExternalMessage)DataCodecKit.decode((byte[])dataContent, ExternalMessage.class);
                clientUserChannel.read(externalMessage, barSkeleton);
            }
        };
        clientUserChannel.setClientChannel(externalMessage -> {
            byte[] bytes = DataCodecKit.encode((Object)externalMessage);
            webSocketClient.send(bytes);
        });
        clientUser.getClientUserInputCommands().start();
        webSocketClient.connect();
    }
}

