/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.external.client.command;

import com.iohao.game.action.skeleton.core.DataCodecKit;
import com.iohao.game.external.client.command.CommandResult;
import com.iohao.game.external.client.command.InputCallback;
import com.iohao.game.external.core.message.ExternalMessage;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandCallback {
    private static final Logger log = LoggerFactory.getLogger(CommandCallback.class);
    public int msgId;
    public Class<?> responseClass;
    public InputCallback callback;
    public Object requestData;

    public void callback(ExternalMessage externalMessage) {
        CommandResult commandResult = new CommandResult();
        commandResult.externalMessage = externalMessage;
        commandResult.requestData = this.requestData;
        byte[] data = externalMessage.getData();
        if (Objects.nonNull(this.responseClass)) {
            commandResult.value = DataCodecKit.decode((byte[])data, this.responseClass);
        }
        if (Objects.nonNull(this.callback)) {
            this.callback.callback(commandResult);
        }
    }

    public int getMsgId() {
        return this.msgId;
    }

    public Class<?> getResponseClass() {
        return this.responseClass;
    }

    public InputCallback getCallback() {
        return this.callback;
    }

    public Object getRequestData() {
        return this.requestData;
    }

    public void setMsgId(int msgId) {
        this.msgId = msgId;
    }

    public void setResponseClass(Class<?> responseClass) {
        this.responseClass = responseClass;
    }

    public void setCallback(InputCallback callback) {
        this.callback = callback;
    }

    public void setRequestData(Object requestData) {
        this.requestData = requestData;
    }
}

