/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.common.validation;

import com.iohao.game.common.kit.ClassScanner;
import com.iohao.game.common.kit.io.ResourceKit;
import com.iohao.game.common.kit.log.IoGameLoggerFactory;
import com.iohao.game.common.validation.Validator;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public final class Validation {
    static final Logger log = IoGameLoggerFactory.getLoggerCommon();
    static final String fileName = "META-INF/ioGame/com.iohao.game.common.validation.Validator";
    static final String defaultValidator = "com.iohao.game.common.validation.support.JakartaValidator";
    private static volatile Validator validator;
    static Lock lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Validator getValidator() throws Exception {
        if (validator != null) {
            return validator;
        }
        lock.lock();
        try {
            if (validator != null) {
                Validator validator = Validation.validator;
                return validator;
            }
            String className = Validation.getValidatorClassName();
            String packageName = Validation.getValidatorPackage(className);
            ClassScanner classScanner = new ClassScanner(packageName, clazz -> clazz.getName().equals(className));
            List classList = classScanner.listScan();
            if (classList.isEmpty()) {
                throw new Exception("\u7f3a\u5c11\u7c7b: " + className);
            }
            Class clazz2 = (Class)classList.get(0);
            validator = (Validator)clazz2.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        finally {
            lock.unlock();
        }
        return validator;
    }

    private static String getValidatorClassName() {
        String className = null;
        try {
            className = ResourceKit.readStr((String)fileName, (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            log.info("\u8bfb\u53d6 {} \u5931\u8d25\uff0c\u5c06\u4f7f\u7528\u9ed8\u8ba4\u7c7b {} \u6765\u5904\u7406", (Object)fileName, (Object)defaultValidator);
        }
        if (StringUtils.isBlank((String)className)) {
            className = defaultValidator;
        }
        return StringUtils.trim((String)className);
    }

    private static String getValidatorPackage(String className) {
        List<String> segments = Arrays.stream(className.split("\\.")).toList();
        return segments.stream().limit(segments.size() - 1).collect(Collectors.joining("/"));
    }

    private Validation() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        lock = new ReentrantLock();
    }
}

