/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.toy;

import com.iohao.game.action.skeleton.toy.ToyLine;
import com.iohao.game.action.skeleton.toy.ToyTable;
import com.iohao.game.action.skeleton.toy.ToyTableRender;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.fusesource.jansi.Ansi;

final class ToyTableRegion {
    Map<String, ToyLine> lineMap = new LinkedHashMap<String, ToyLine>();
    String head;
    String prefix = " ";
    String suffix = " ";
    String fill = " ";
    int valueMaxLen;
    int keyMaxLen;
    String separatorLine;
    ToyTable table;

    ToyTableRegion() {
    }

    void putLine(String key, String value) {
        ToyLine line = this.lineMap.get(key);
        if (Objects.isNull(line)) {
            line = new ToyLine();
            line.key = key;
            line.value = value;
            line.region = this;
            this.lineMap.putIfAbsent(key, line);
            line = this.lineMap.get(key);
            this.counter(line);
        }
    }

    void putAll(Map<?, ?> map) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.putLine(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
    }

    void render() {
        StringBuilder bodyBuilder;
        ToyTableRender tableRender = this.table.tableRender;
        tableRender.line(this.keyMaxLen, this.valueMaxLen);
        String renderHead = this.renderHead();
        tableRender.headContent.append(renderHead);
        int num = 0;
        for (ToyLine line : this.lineMap.values()) {
            bodyBuilder = tableRender.bodyContentList.get(num);
            ++num;
            String lineRender = line.render();
            bodyBuilder.append(lineRender);
        }
        int bodyMaxNum = this.table.bodyMaxNum;
        for (int i = num; i < bodyMaxNum; ++i) {
            bodyBuilder = tableRender.bodyContentList.get(i);
            int appendNum = this.keyMaxLen + this.valueMaxLen + this.prefix.length() + this.suffix.length() + 2;
            this.append(bodyBuilder, this.fill, appendNum);
        }
    }

    String renderHead() {
        Ansi.Color color = this.table.color;
        String head = Ansi.ansi().fg(color).a(this.head).reset().toString();
        StringBuilder headBuilder = new StringBuilder();
        headBuilder.append(this.prefix);
        headBuilder.append(head);
        int num = this.valueMaxLen + this.keyMaxLen - this.prefix.length() - this.suffix.length() - this.fill.length() - 1;
        this.append(headBuilder, this.fill, num);
        headBuilder.append(this.suffix);
        return headBuilder.toString();
    }

    private void append(StringBuilder builder, String c, int num) {
        builder.append(c.repeat(Math.max(0, num + 1)));
    }

    private void keyLine() {
        this.separatorLine = "-".repeat(Math.max(0, this.keyMaxLen)) + "+";
    }

    private void counter(ToyLine line) {
        if (line.key.length() > this.keyMaxLen) {
            this.keyMaxLen = line.key.length();
            this.keyLine();
        }
        if (line.value.length() > this.valueMaxLen) {
            this.valueMaxLen = line.value.length();
        }
        if (this.head.length() > this.keyMaxLen) {
            this.keyMaxLen = this.head.length();
            this.keyLine();
        }
    }
}

