/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.toy;

import com.iohao.game.action.skeleton.toy.BannerColorStrategy;
import com.iohao.game.action.skeleton.toy.ToyTableRegion;
import com.iohao.game.action.skeleton.toy.ToyTableRender;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.fusesource.jansi.Ansi;

final class ToyTable {
    Ansi.Color color = BannerColorStrategy.anyColor();
    Map<String, ToyTableRegion> regionMap = new LinkedHashMap<String, ToyTableRegion>();
    ToyTableRender tableRender;
    int bodyMaxNum;

    ToyTable() {
    }

    void render() {
        this.bodyMaxNum = this.countRegionMaxLine();
        this.tableRender = new ToyTableRender(this.bodyMaxNum);
        int size = this.regionMap.size();
        int eleNum = 0;
        for (ToyTableRegion region : this.regionMap.values()) {
            boolean lastEle;
            region.render();
            if (lastEle = size == ++eleNum) continue;
            this.tableRender.next();
        }
        this.tableRender.render();
    }

    int countRegionMaxLine() {
        int lineMax = 0;
        for (ToyTableRegion region : this.regionMap.values()) {
            int size = region.lineMap.size();
            if (size <= lineMax) continue;
            lineMax = size;
        }
        return lineMax;
    }

    ToyTableRegion getRegion(String regionName) {
        ToyTableRegion region = this.regionMap.get(regionName);
        if (Objects.isNull(region)) {
            region = new ToyTableRegion();
            region.head = regionName;
            region.table = this;
            this.regionMap.putIfAbsent(regionName, region);
            region = this.regionMap.get(regionName);
        }
        return region;
    }
}

