/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.toy;

import com.iohao.game.action.skeleton.IoGameVersion;
import com.iohao.game.action.skeleton.toy.BannerColorStrategy;
import com.iohao.game.action.skeleton.toy.BannerData;
import com.iohao.game.action.skeleton.toy.BreakingNews;
import com.iohao.game.action.skeleton.toy.InternalMemory;
import com.iohao.game.action.skeleton.toy.ToyTable;
import com.iohao.game.action.skeleton.toy.ToyTableRegion;
import com.iohao.game.common.kit.RandomKit;
import com.iohao.game.common.kit.concurrent.TaskKit;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.UnaryOperator;

public final class IoGameBanner {
    public static String flag21;
    private final AtomicBoolean trigger = new AtomicBoolean(false);
    private Date startTime = new Date();
    private CountDownLatch countDownLatch = new CountDownLatch(1);

    public static void render() {
        if (!IoGameBanner.me().trigger.compareAndSet(false, true)) {
            return;
        }
        IoGameBanner.me().renderBanner();
    }

    public void initCountDownLatch(int num) {
        this.countDownLatch = new CountDownLatch(num);
    }

    public void countDown() {
        if (Objects.nonNull(this.countDownLatch)) {
            this.countDownLatch.countDown();
        }
    }

    private void renderBanner() {
        Runnable runnable = () -> {
            try {
                if (Objects.nonNull(IoGameBanner.me().countDownLatch)) {
                    IoGameBanner.me().countDownLatch.await(5L, TimeUnit.SECONDS);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ToyTable table = new ToyTable();
            ToyTableRegion ioGameRegion = table.getRegion("ioGame");
            ioGameRegion.putLine("pid", IoGameBanner.getPid());
            ioGameRegion.putLine("version", IoGameVersion.VERSION);
            ioGameRegion.putLine("document", "http://game.iohao.com");
            InternalMemory internalMemory = new InternalMemory();
            ToyTableRegion memory = table.getRegion("Memory");
            memory.putAll(internalMemory.getMemoryMap());
            this.extractedTime(table);
            this.extractedPrint(table);
            this.extractedIoGameJavadocApi();
            this.extractedAdv();
            this.extractedBreakingNews();
            this.clean();
            System.out.println();
        };
        TaskKit.execute((Runnable)runnable);
    }

    private void clean() {
        this.startTime = null;
        this.countDownLatch = null;
    }

    private void extractedTime(ToyTable table) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        Date endTime = new Date();
        float consumeTime = (float)(endTime.getTime() - this.startTime.getTime()) / 1000.0f;
        String consume = String.format("%.2f s", Float.valueOf(consumeTime));
        ToyTableRegion other = table.getRegion("Time");
        other.putLine("start", simpleDateFormat.format(this.startTime));
        other.putLine("end", simpleDateFormat.format(endTime));
        other.putLine("consume", consume);
    }

    private void extractedBreakingNews() {
        List<BreakingNews.News> newsList = BreakingNews.randomNewsList(2);
        for (BreakingNews.News news : newsList) {
            System.out.printf("| News     | %s%n", news);
        }
        System.out.println("+----------+--------------------------------------------------------------------------------------");
    }

    private void extractedAdv() {
        String s = BreakingNews.randomAdv().toString();
        String builder = "| adv      | %s - %s%n";
        System.out.printf(builder, "\u542f\u52a8\u9879\u5e7f\u544a\u4f4d\u62db\u79df", s);
        System.out.println("+----------+--------------------------------------------------------------------------------------");
    }

    private void extractedIoGameJavadocApi() {
        String s = BreakingNews.ioGameJavadocApi().toString();
        String builder = "| javadoc  | %s%n";
        System.out.printf(builder, s);
        System.out.println("+----------+--------------------------------------------------------------------------------------");
    }

    private void extractedMiss() {
        String desc = "\u5927\u5bb6\u53ef\u4ee5\u6765\u767b\u8bb0\uff0c\u6709\u9700\u8981\u5c55\u793a\u6216\u8bb0\u5ff5\u7684\u5ba0\u7269\u3001\u52a8\u6f2b\u4eba\u7269\u7b49\u5404\u79cd\u4e8b\u7269";
        String builder = "| miss     | %s%n";
        System.out.printf(builder, "\u5973\u5a32:\u4e2d\u56fd\u795e\u8bdd\u4e2d\u7684\u9020\u7269\u4e3b\uff0c\u636e\u8bf4\u521b\u9020\u4e86\u4eba\u7c7b\u548c\u4e16\u754c\u3002", desc);
        builder = "|          | (%s)%n";
        System.out.printf(builder, desc);
        System.out.println("+----------+--------------------------------------------------------------------------------------");
    }

    private void extractedPrint(ToyTable table) {
        List<String> bannerList = new BannerData().listData();
        String banner = (String)RandomKit.randomEle(bannerList);
        UnaryOperator<String> anyFunction = new BannerColorStrategy().anyColorFun();
        String anyBanner = (String)anyFunction.apply(banner);
        System.out.println();
        System.out.println(anyBanner);
        table.render();
    }

    private static String getPid() {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        String name = runtime.getName();
        try {
            return name.substring(0, name.indexOf(64));
        }
        catch (Exception e) {
            return "-1";
        }
    }

    private IoGameBanner() {
    }

    public static IoGameBanner me() {
        flag21 = "ioGame21";
        return Holder.ME;
    }

    private static class Holder {
        static final IoGameBanner ME = new IoGameBanner();

        private Holder() {
        }
    }
}

