/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.toy;

import com.iohao.game.common.kit.RandomKit;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.fusesource.jansi.Ansi;

final class BannerColorStrategy {
    BannerColorStrategy() {
    }

    static Ansi.Color anyColor() {
        List<Ansi.Color> collect = Stream.of(Ansi.Color.values()).filter(color -> color != Ansi.Color.BLUE).filter(color -> color != Ansi.Color.WHITE).filter(color -> color != Ansi.Color.BLACK).filter(color -> color != Ansi.Color.DEFAULT).toList();
        return (Ansi.Color)RandomKit.randomEle(collect);
    }

    UnaryOperator<String> anyColorFun() {
        UnaryOperator colorNon = s -> s;
        UnaryOperator colorSingleFun = this::colorSingle;
        UnaryOperator colorRandomLineFun = this::colorRandomLine;
        UnaryOperator colorRandomFun = this::colorRandom;
        UnaryOperator colorRandomColumnFun = this::colorRandomColumn;
        UnaryOperator colorColumnFun = this::colorColumn;
        ArrayList<UnaryOperator> functionList = new ArrayList<UnaryOperator>();
        functionList.add(colorNon);
        functionList.add(colorSingleFun);
        functionList.add(colorRandomColumnFun);
        functionList.add(colorColumnFun);
        functionList.add(colorColumnFun);
        functionList.add(colorRandomLineFun);
        functionList.add(colorRandomLineFun);
        functionList.add(colorRandomLineFun);
        functionList.add(colorRandomFun);
        functionList.add(colorRandomFun);
        functionList.add(colorRandomFun);
        return (UnaryOperator)RandomKit.randomEle(functionList);
    }

    private String colorRandomLine(String banner) {
        List<Ansi.Color> colorList = this.listColor();
        Ansi ansi = Ansi.ansi();
        char[] array = banner.toCharArray();
        int anInt = RandomKit.randomInt((int)colorList.size());
        Ansi.Color color = colorList.get(anInt);
        for (char c : array) {
            ansi.fg(color).a(c);
            if (c != '\n') continue;
            color = (Ansi.Color)RandomKit.randomEle(colorList);
        }
        return ansi.reset().toString();
    }

    private String colorSingle(String banner) {
        Ansi.Color color = BannerColorStrategy.randomColor();
        Ansi ansi = Ansi.ansi().fg(color).a(banner);
        return ansi.reset().toString();
    }

    private String colorRandom(String banner) {
        char[] array;
        List<Ansi.Color> colorList = this.listColor();
        Ansi ansi = Ansi.ansi();
        for (char c : array = banner.toCharArray()) {
            Ansi.Color color = (Ansi.Color)RandomKit.randomEle(colorList);
            ansi.fg(color).a(c);
        }
        return ansi.reset().toString();
    }

    private String colorRandomColumn(String banner) {
        int widthLen = RandomKit.randomInt((int)1, (int)10);
        Ansi.Color color = BannerColorStrategy.randomColor();
        Ansi ansi = Ansi.ansi();
        char[] array = banner.toCharArray();
        for (int i = 0; i < array.length; ++i) {
            char c = array[i];
            if (i % widthLen == 0) {
                color = BannerColorStrategy.randomColor();
                widthLen = RandomKit.randomInt((int)1, (int)10);
            }
            ansi.fg(color).a(c);
        }
        return ansi.reset().toString();
    }

    private String colorColumn(String banner) {
        Ansi ansi = Ansi.ansi();
        TheColorColumn colorColumn = TheColorColumn.create();
        ArrayList<TheColorColumn> list = new ArrayList<TheColorColumn>();
        list.add(colorColumn);
        int lineNum = 0;
        for (char c : banner.toCharArray()) {
            if (c == '\n') {
                lineNum = 0;
                colorColumn = (TheColorColumn)list.get(lineNum);
                colorColumn.reset();
            }
            if (!colorColumn.has()) {
                if (++lineNum >= list.size()) {
                    colorColumn = TheColorColumn.create();
                    list.add(colorColumn);
                }
                colorColumn = (TheColorColumn)list.get(lineNum);
                colorColumn.reset();
            }
            colorColumn.render(ansi, c);
        }
        return ansi.reset().toString();
    }

    private List<Ansi.Color> listColor() {
        return Stream.of(Ansi.Color.values()).filter(color -> color != Ansi.Color.BLACK).toList();
    }

    private static Ansi.Color randomColor() {
        List<Ansi.Color> collect = Stream.of(Ansi.Color.values()).filter(color -> color != Ansi.Color.BLACK).toList();
        return (Ansi.Color)RandomKit.randomEle(collect);
    }

    private static class TheColorColumn {
        Ansi.Color color;
        int widthLen;
        int num;

        TheColorColumn(Ansi.Color color, int widthLen) {
            this.color = color;
            this.widthLen = widthLen;
            this.num = widthLen;
        }

        void reset() {
            this.num = this.widthLen;
        }

        static TheColorColumn create() {
            int widthLen = RandomKit.randomInt((int)1, (int)5);
            Ansi.Color color = BannerColorStrategy.randomColor();
            return new TheColorColumn(color, widthLen);
        }

        void render(Ansi ansi, char c) {
            --this.num;
            ansi.fg(this.color).a(c);
        }

        boolean has() {
            return this.num > 0;
        }
    }
}

