/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.pulse.runner;

import com.iohao.game.action.skeleton.core.BarSkeleton;
import com.iohao.game.action.skeleton.core.SkeletonAttr;
import com.iohao.game.action.skeleton.core.commumication.BrokerClientContext;
import com.iohao.game.action.skeleton.core.runner.Runner;
import com.iohao.game.action.skeleton.protocol.processor.SimpleServerInfo;
import com.iohao.game.action.skeleton.pulse.Pulses;
import com.iohao.game.action.skeleton.pulse.core.PulseTransmit;
import com.iohao.game.action.skeleton.pulse.core.consumer.PulseConsumers;
import com.iohao.game.action.skeleton.pulse.core.producer.PulseProducers;
import com.iohao.game.action.skeleton.pulse.message.PulseSignalMessage;
import com.iohao.game.action.skeleton.pulse.message.PulseSignalRequest;
import com.iohao.game.action.skeleton.pulse.message.PulseSignalResponse;
import java.util.Objects;

public class CreatePulsesRunner
implements Runner {
    @Override
    public void onStart(BarSkeleton skeleton) {
        BrokerClientContext brokerClientContext = (BrokerClientContext)skeleton.option(SkeletonAttr.brokerClientContext);
        Integer sourceClientId = (Integer)skeleton.option(SkeletonAttr.logicServerIdHash);
        Pulses pulses = this.getPulses(skeleton);
        PulseConsumers pulseConsumers = pulses.getPulseConsumers();
        pulseConsumers.setPulseTransmit(new ConsumerTransmit(brokerClientContext));
        skeleton.option(SkeletonAttr.consumerPulseTransmit, pulseConsumers.getPulseTransmit());
        PulseProducers pulseProducers = pulses.getPulseProducers();
        pulseProducers.setPulseTransmit(new ProducerTransmit(brokerClientContext, sourceClientId));
        skeleton.option(SkeletonAttr.producerPulseTransmit, pulseProducers.getPulseTransmit());
        pulseProducers.startup();
    }

    protected Pulses getPulses(BarSkeleton skeleton) {
        Pulses pulses = (Pulses)skeleton.option(SkeletonAttr.pulses);
        if (Objects.isNull(pulses)) {
            pulses = new Pulses();
            skeleton.option(SkeletonAttr.pulses, pulses);
        }
        return pulses;
    }

    record ConsumerTransmit(BrokerClientContext brokerClientContext) implements PulseTransmit
    {
        @Override
        public void transmit(PulseSignalMessage message) {
            if (message instanceof PulseSignalResponse) {
                PulseSignalResponse response = (PulseSignalResponse)message;
                SimpleServerInfo simpleServerInfo = this.brokerClientContext.getSimpleServerInfo();
                response.setSimpleServerInfo(simpleServerInfo);
                this.brokerClientContext.sendResponse(message);
            }
        }
    }

    record ProducerTransmit(BrokerClientContext brokerClientContext, int sourceClientId) implements PulseTransmit
    {
        @Override
        public void transmit(PulseSignalMessage message) {
            PulseSignalRequest request;
            if (message instanceof PulseSignalRequest && (request = (PulseSignalRequest)message).getSignalType() != 0) {
                message.setSourceClientId(this.sourceClientId);
                this.brokerClientContext.sendResponse(message);
            }
        }
    }
}

