/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.pulse.core.producer;

import com.iohao.game.action.skeleton.pulse.core.PulseTransmit;
import com.iohao.game.action.skeleton.pulse.core.producer.PulseProducer;
import com.iohao.game.action.skeleton.pulse.core.producer.PulseProducers;
import com.iohao.game.action.skeleton.pulse.core.producer.PulseSignalResponseAccept;
import com.iohao.game.action.skeleton.pulse.message.PulseSignalMessage;
import com.iohao.game.action.skeleton.pulse.message.PulseSignalRequest;
import com.iohao.game.action.skeleton.pulse.message.PulseSignalResponse;
import com.iohao.game.common.kit.ExecutorKit;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.jctools.maps.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultPulseProducers
implements PulseProducers {
    private static final Logger log = LoggerFactory.getLogger(DefaultPulseProducers.class);
    static final ScheduledExecutorService executor = ExecutorKit.newSingleScheduled((String)DefaultPulseProducers.class.getSimpleName());
    private final Map<String, PulseProducer<?>> map = new NonBlockingHashMap();
    private final List<PulseTask> taskList = new CopyOnWriteArrayList<PulseTask>();
    private final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
    private final Map<String, PulseSignalResponseAccept<?>> responseAcceptMap = new NonBlockingHashMap();
    private PulseTransmit pulseTransmit;

    @Override
    public void addResponseAccept(PulseSignalResponseAccept<?> responseAccept) {
        String channel = responseAccept.channel();
        this.responseAcceptMap.put(channel, responseAccept);
    }

    @Override
    public void addPulseProducer(PulseProducer<?> pulseProducer) {
        String channel = pulseProducer.channel();
        PulseProducer<?> pulse = this.map.putIfAbsent(channel, pulseProducer);
        if (Objects.nonNull(pulse)) {
            return;
        }
        this.taskList.add(new PulseTask(pulseProducer));
    }

    @Override
    public void startup() {
        if (this.atomicBoolean.compareAndSet(false, true)) {
            Consumer<PulseSignalRequest> consumer = request -> this.pulseTransmit.transmit((PulseSignalMessage)request);
            Runnable runnable = () -> this.taskList.forEach(task -> task.ifPresent(consumer));
            executor.scheduleAtFixedRate(runnable, 1L, 1L, TimeUnit.SECONDS);
        }
    }

    @Override
    public void acceptPulseSign(PulseSignalResponse response) {
        String channel = response.getChannel();
        Optional.ofNullable(this.map.get(channel)).ifPresent(pulseProducer -> pulseProducer.accept((Serializable)response.getData(), response));
        Optional.ofNullable(this.responseAcceptMap.get(channel)).ifPresent(pulseProducer -> pulseProducer.accept(response.getData(), response));
    }

    @Override
    public void setPulseTransmit(PulseTransmit pulseTransmit) {
        this.pulseTransmit = pulseTransmit;
    }

    @Override
    public PulseTransmit getPulseTransmit() {
        return this.pulseTransmit;
    }

    private static class PulseTask {
        final PulseProducer<?> pulseProducer;
        int count;

        PulseTask(PulseProducer<?> pulseProducer) {
            this.pulseProducer = pulseProducer;
            this.count = pulseProducer.period();
        }

        void ifPresent(Consumer<PulseSignalRequest> consumer) {
            --this.count;
            if (this.count != 0) {
                return;
            }
            try {
                PulseSignalRequest request = this.pulseProducer.createMessage();
                request.setChannel(this.pulseProducer.channel());
                if (request.getSignalType() == 0) {
                    String text = "\u8bf7\u6dfb\u52a0\u8109\u51b2\u4fe1\u53f7\u7c7b\u578b request.addSignalType(SignalType)\nclass : {}\nrequest: {}\n";
                    log.error(text, (Object)this.pulseProducer.getClass().getSimpleName(), (Object)request);
                    this.count = this.pulseProducer.period();
                    return;
                }
                consumer.accept(request);
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
            this.count = this.pulseProducer.period();
        }
    }
}

