/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.pulse.core.consumer;

import com.iohao.game.action.skeleton.pulse.core.PulseTransmit;
import com.iohao.game.action.skeleton.pulse.core.consumer.PulseConsumer;
import com.iohao.game.action.skeleton.pulse.core.consumer.PulseConsumers;
import com.iohao.game.action.skeleton.pulse.message.PulseSignalRequest;
import com.iohao.game.action.skeleton.pulse.message.PulseSignalResponse;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.jctools.maps.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultPulseConsumers
implements PulseConsumers {
    private static final Logger log = LoggerFactory.getLogger(DefaultPulseConsumers.class);
    private final Map<String, PulseConsumer<?>> map = new NonBlockingHashMap();
    private PulseTransmit pulseTransmit;

    @Override
    public void addPulseConsumer(PulseConsumer<?> pulseConsumer) {
        String channel = pulseConsumer.channel();
        this.map.putIfAbsent(channel, pulseConsumer);
    }

    @Override
    public void acceptPulseSign(PulseSignalRequest request) {
        String channel = request.getChannel();
        PulseConsumer<?> pulseConsumer = this.map.get(channel);
        if (Objects.isNull(pulseConsumer)) {
            return;
        }
        try {
            int sourceClientId = request.getSourceClientId();
            Serializable data = pulseConsumer.accept((Serializable)request.getData(), request);
            if (Objects.isNull(data)) {
                return;
            }
            PulseSignalResponse response = new PulseSignalResponse();
            response.setChannel(channel);
            response.setSourceClientId(sourceClientId);
            response.setData(data);
            this.pulseTransmit.transmit(response);
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
    }

    @Override
    public void setPulseTransmit(PulseTransmit pulseTransmit) {
        this.pulseTransmit = pulseTransmit;
    }

    @Override
    public PulseTransmit getPulseTransmit() {
        return this.pulseTransmit;
    }
}

