/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.protocol.wrapper;

import com.iohao.game.action.skeleton.protocol.wrapper.BoolValue;
import com.iohao.game.action.skeleton.protocol.wrapper.BoolValueList;
import com.iohao.game.action.skeleton.protocol.wrapper.ByteValueList;
import com.iohao.game.action.skeleton.protocol.wrapper.IntValue;
import com.iohao.game.action.skeleton.protocol.wrapper.IntValueList;
import com.iohao.game.action.skeleton.protocol.wrapper.LongValue;
import com.iohao.game.action.skeleton.protocol.wrapper.LongValueList;
import com.iohao.game.action.skeleton.protocol.wrapper.StringValue;
import com.iohao.game.action.skeleton.protocol.wrapper.StringValueList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class WrapperKit {
    static final Set<Class<?>> wrapperTypeSet = Set.of(Integer.TYPE, Integer.class, IntValue.class, Long.TYPE, Long.class, LongValue.class, Boolean.TYPE, Boolean.class, BoolValue.class, String.class, StringValue.class);
    static final Map<Class<?>, Class<?>> refTypeMap = new HashMap();

    public static IntValue of(int value) {
        return IntValue.of(value);
    }

    public static IntValueList ofListIntValue(List<Integer> values) {
        return IntValueList.of(values);
    }

    public static BoolValue of(boolean value) {
        return BoolValue.of(value);
    }

    public static BoolValueList ofListBoolValue(List<Boolean> values) {
        return BoolValueList.of(values);
    }

    public static LongValue of(long value) {
        return LongValue.of(value);
    }

    public static LongValueList ofListLongValue(List<Long> values) {
        return LongValueList.of(values);
    }

    public static StringValue of(String value) {
        return StringValue.of(value);
    }

    public static StringValueList ofListStringValue(List<String> values) {
        return StringValueList.of(values);
    }

    public static <T> ByteValueList ofListByteValue(List<T> values) {
        return WrapperKit.ofList(values);
    }

    public static <T> ByteValueList ofList(List<T> values) {
        return ByteValueList.ofList(values);
    }

    public static <T> ByteValueList ofListByteValue(Collection<T> values) {
        return ByteValueList.ofList(values);
    }

    public static boolean isWrapper(Class<?> clazz) {
        return wrapperTypeSet.contains(clazz);
    }

    public static Optional<Class<?>> optionalRefType(Class<?> clazz) {
        return Optional.ofNullable(refTypeMap.get(clazz));
    }

    private WrapperKit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        refTypeMap.put(Integer.TYPE, IntValue.class);
        refTypeMap.put(Integer.class, IntValue.class);
        refTypeMap.put(IntValue.class, IntValue.class);
        refTypeMap.put(Long.TYPE, LongValue.class);
        refTypeMap.put(Long.class, LongValue.class);
        refTypeMap.put(LongValue.class, LongValue.class);
        refTypeMap.put(Boolean.TYPE, BoolValue.class);
        refTypeMap.put(Boolean.class, BoolValue.class);
        refTypeMap.put(BoolValue.class, BoolValue.class);
        refTypeMap.put(String.class, StringValue.class);
        refTypeMap.put(StringValue.class, StringValue.class);
    }
}

