/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.protocol;

import com.iohao.game.action.skeleton.core.DataCodecKit;
import com.iohao.game.action.skeleton.core.exception.MsgExceptionInfo;
import com.iohao.game.action.skeleton.protocol.HeadMetadata;
import com.iohao.game.action.skeleton.protocol.RequestMessage;
import com.iohao.game.action.skeleton.protocol.ResponseMessage;
import com.iohao.game.common.consts.CommonConst;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;

public abstract sealed class BarMessage
implements Serializable
permits RequestMessage, ResponseMessage {
    private static final long serialVersionUID = 562068269463876111L;
    protected int responseStatus;
    protected String validatorMsg;
    protected HeadMetadata headMetadata;
    protected String dataClass;
    protected byte[] data;

    public BarMessage setData(byte[] data) {
        this.data = data;
        return this;
    }

    public BarMessage setData(Object data) {
        if (Objects.isNull(data)) {
            return this.setData(CommonConst.emptyBytes);
        }
        this.dataClass = data.getClass().getName();
        byte[] bytes = DataCodecKit.encode(data);
        return this.setData(bytes);
    }

    public BarMessage setValidatorMsg(String validatorMsg) {
        if (validatorMsg != null) {
            this.validatorMsg = validatorMsg;
        }
        return this;
    }

    public BarMessage setError(MsgExceptionInfo msgExceptionInfo) {
        this.responseStatus = msgExceptionInfo.getCode();
        this.validatorMsg = msgExceptionInfo.getMsg();
        return this;
    }

    public boolean hasError() {
        return this.responseStatus != 0;
    }

    public int getResponseStatus() {
        return this.responseStatus;
    }

    public String getValidatorMsg() {
        return this.validatorMsg;
    }

    public HeadMetadata getHeadMetadata() {
        return this.headMetadata;
    }

    public String getDataClass() {
        return this.dataClass;
    }

    public byte[] getData() {
        return this.data;
    }

    public BarMessage setResponseStatus(int responseStatus) {
        this.responseStatus = responseStatus;
        return this;
    }

    public BarMessage setHeadMetadata(HeadMetadata headMetadata) {
        this.headMetadata = headMetadata;
        return this;
    }

    public BarMessage setDataClass(String dataClass) {
        this.dataClass = dataClass;
        return this;
    }

    public String toString() {
        return "BarMessage(responseStatus=" + this.getResponseStatus() + ", validatorMsg=" + this.getValidatorMsg() + ", headMetadata=" + String.valueOf(this.getHeadMetadata()) + ", dataClass=" + this.getDataClass() + ", data=" + Arrays.toString(this.getData()) + ")";
    }
}

