/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.kit;

import com.iohao.game.action.skeleton.core.BarMessageKit;
import com.iohao.game.action.skeleton.core.CmdInfo;
import com.iohao.game.action.skeleton.core.commumication.CommunicationAggregationContext;
import com.iohao.game.action.skeleton.core.flow.FlowContext;
import com.iohao.game.action.skeleton.core.flow.attr.FlowAttr;
import com.iohao.game.action.skeleton.protocol.ResponseMessage;
import com.iohao.game.common.kit.CollKit;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.jctools.maps.NonBlockingHashSet;

public class RangeBroadcast {
    private final CommunicationAggregationContext aggregationContext;
    private final Set<Long> userIds = new NonBlockingHashSet();
    private ResponseMessage responseMessage;
    private boolean doSend = true;
    private boolean checkEmptyUser = true;

    public RangeBroadcast(CommunicationAggregationContext aggregationContext) {
        Objects.requireNonNull(aggregationContext);
        this.aggregationContext = aggregationContext;
    }

    public RangeBroadcast(FlowContext flowContext) {
        this(flowContext.option(FlowAttr.aggregationContext));
    }

    public final void execute() {
        this.logic();
        if (!this.doSend) {
            return;
        }
        this.trick();
        Objects.requireNonNull(this.responseMessage);
        this.broadcast();
    }

    protected void logic() {
    }

    protected void trick() {
    }

    protected void broadcast() {
        boolean emptyUser = CollKit.isEmpty(this.userIds);
        if (this.checkEmptyUser && emptyUser) {
            throw new RuntimeException("\u6ca1\u6709\u6dfb\u52a0\u6d88\u606f\u63a8\u9001\u4eba " + String.valueOf(this.getClass()));
        }
        if (!emptyUser) {
            this.aggregationContext.broadcast(this.responseMessage, this.userIds);
        }
    }

    public RangeBroadcast setResponseMessage(ResponseMessage responseMessage) {
        this.responseMessage = responseMessage;
        return this;
    }

    public RangeBroadcast setResponseMessage(CmdInfo cmdInfo, Object bizData) {
        ResponseMessage responseMessage = BarMessageKit.createResponseMessage(cmdInfo, bizData);
        return this.setResponseMessage(responseMessage);
    }

    public RangeBroadcast setResponseMessage(CmdInfo cmdInfo) {
        ResponseMessage responseMessage = BarMessageKit.createResponseMessage(cmdInfo);
        return this.setResponseMessage(responseMessage);
    }

    public RangeBroadcast addUserId(Collection<Long> userIds) {
        this.userIds.addAll(userIds);
        return this;
    }

    public RangeBroadcast addUserId(long userId) {
        this.userIds.add(userId);
        return this;
    }

    public RangeBroadcast addUserId(Collection<Long> userIds, long excludeUserId) {
        return this.addUserId(userIds).removeUserId(excludeUserId);
    }

    public RangeBroadcast removeUserId(long excludeUserId) {
        if (excludeUserId > 0L) {
            this.userIds.remove(excludeUserId);
        }
        return this;
    }

    protected void disableSend() {
        this.doSend = false;
    }

    public RangeBroadcast disableEmptyUserCheck() {
        this.checkEmptyUser = false;
        return this;
    }

    protected CommunicationAggregationContext getAggregationContext() {
        return this.aggregationContext;
    }
}

