/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.kit;

import com.iohao.game.action.skeleton.core.BarSkeleton;
import com.iohao.game.action.skeleton.core.flow.FlowContext;
import com.iohao.game.action.skeleton.core.flow.attr.FlowAttr;
import com.iohao.game.action.skeleton.kit.ExecutorSelectEnum;
import com.iohao.game.action.skeleton.protocol.HeadMetadata;
import com.iohao.game.common.kit.concurrent.executor.ExecutorRegion;
import com.iohao.game.common.kit.concurrent.executor.ThreadExecutor;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;

public final class ExecutorSelectKit {
    public static boolean processLogic(BarSkeleton barSkeleton, FlowContext flowContext) {
        HeadMetadata headMetadata = flowContext.getRequest().getHeadMetadata();
        ThreadExecutor threadExecutor = ExecutorSelectKit.getThreadExecutor(barSkeleton, headMetadata);
        if (Objects.isNull(threadExecutor)) {
            return false;
        }
        flowContext.option(FlowAttr.threadExecutor, threadExecutor);
        threadExecutor.execute(() -> barSkeleton.handle(flowContext));
        return true;
    }

    private static ThreadExecutor getThreadExecutor(BarSkeleton barSkeleton, HeadMetadata headMetadata) {
        ExecutorSelectEnum executorSelect;
        long executorIndex = ExecutorSelectKit.getExecutorIndex(headMetadata);
        ExecutorRegion executorRegion = barSkeleton.getExecutorRegion();
        ExecutorSelectEnum executorSelectEnum = executorSelect = headMetadata.getExecutorSelect();
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"userVirtualExecutor", "userExecutor"}, (ExecutorSelectEnum)executorSelectEnum, n)) {
            case -1 -> executorRegion.getUserThreadExecutor(executorIndex);
            case 0 -> executorRegion.getUserVirtualThreadExecutor(executorIndex);
            case 1 -> executorRegion.getUserThreadExecutor(executorIndex);
            default -> null;
        };
    }

    public static long getExecutorIndex(HeadMetadata headMetadata) {
        long userId = headMetadata.getUserId();
        if (userId != 0L) {
            return userId;
        }
        return Optional.ofNullable(headMetadata.getChannelId()).map(String::hashCode).map(Math::abs).orElseGet(headMetadata::getCmdMerge).intValue();
    }

    private ExecutorSelectKit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

