/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.ext.spring;

import com.iohao.game.action.skeleton.core.ActionCommand;
import com.iohao.game.action.skeleton.core.ActionFactoryBean;
import com.iohao.game.action.skeleton.core.DependencyInjectionPart;
import java.util.Objects;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

public class ActionFactoryBeanForSpring<T>
implements ActionFactoryBean<T>,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    boolean spring;

    @Override
    public T getBean(ActionCommand actionCommand) {
        Class<?> actionControllerClazz = actionCommand.getActionControllerClazz();
        return (T)this.applicationContext.getBean(actionControllerClazz);
    }

    @Override
    public T getBean(Class<?> actionControllerClazz) {
        return (T)this.applicationContext.getBean(actionControllerClazz);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Objects.requireNonNull(applicationContext);
        this.initDependencyInjectionPart();
        this.spring = true;
        this.applicationContext = applicationContext;
    }

    private void initDependencyInjectionPart() {
        DependencyInjectionPart dependencyInjectionPart = DependencyInjectionPart.me();
        dependencyInjectionPart.setInjection(true);
        dependencyInjectionPart.setAnnotationClass(Component.class);
        dependencyInjectionPart.setActionFactoryBean(this);
    }

    private ActionFactoryBeanForSpring() {
    }

    public static ActionFactoryBeanForSpring me() {
        return Holder.ME;
    }

    public boolean isSpring() {
        return this.spring;
    }

    private static class Holder {
        static final ActionFactoryBeanForSpring ME = new ActionFactoryBeanForSpring();

        private Holder() {
        }
    }
}

