/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.eventbus;

import com.esotericsoftware.reflectasm.ConstructorAccess;
import com.esotericsoftware.reflectasm.MethodAccess;
import com.iohao.game.action.skeleton.eventbus.EventBusKit;
import com.iohao.game.action.skeleton.eventbus.EventBusMessage;
import com.iohao.game.action.skeleton.eventbus.EventSubscribe;
import com.iohao.game.action.skeleton.eventbus.ExecutorSelector;
import com.iohao.game.action.skeleton.eventbus.Subscriber;
import com.iohao.game.action.skeleton.eventbus.SubscriberInvoke;
import com.iohao.game.action.skeleton.eventbus.SubscriberInvokeCreator;
import com.iohao.game.common.kit.collect.ListMultiMap;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.jctools.maps.NonBlockingHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SubscriberRegistry {
    private static final Logger log = LoggerFactory.getLogger(SubscriberRegistry.class);
    static final AtomicLong subscriberId = new AtomicLong();
    final ListMultiMap<Class<?>, Subscriber> subscriberMultiMap = ListMultiMap.create();
    final Set<Class<?>> eventBusSubscriberSet = new NonBlockingHashSet();

    SubscriberRegistry() {
    }

    void register(Object eventBusSubscriber, SubscriberInvokeCreator subscriberInvokeCreator) {
        Class<?> clazz = eventBusSubscriber.getClass();
        if (!this.eventBusSubscriberSet.add(clazz)) {
            throw new RuntimeException("\u5df2\u7ecf\u5b58\u5728 " + String.valueOf(clazz));
        }
        MethodAccess methodAccess = MethodAccess.get(clazz);
        ConstructorAccess constructorAccess = ConstructorAccess.get(clazz);
        this.streamMethod(clazz).forEach(method -> {
            Parameter parameter = method.getParameters()[0];
            String methodName = method.getName();
            Class<?> parameterClass = parameter.getType();
            int methodIndex = methodAccess.getIndex(methodName, new Class[]{parameterClass});
            EventSubscribe annotation = method.getAnnotation(EventSubscribe.class);
            ExecutorSelector executorSelector = annotation.value();
            int order = Math.abs(annotation.order());
            Subscriber subscriber = new Subscriber(subscriberId.incrementAndGet()).setMethodAccess(methodAccess).setConstructorAccess(constructorAccess).setMethodName(methodName).setMethod((Method)method).setMethodIndex(methodIndex).setTargetClazz(clazz).setTarget(eventBusSubscriber).setParameterName(parameter.getName()).setParameterClass(parameterClass).setOrder(order).setExecutorSelect(executorSelector);
            SubscriberInvoke subscriberInvoke = subscriberInvokeCreator.create(subscriber);
            subscriber.setSubscriberInvoke(subscriberInvoke);
            this.subscriberMultiMap.put(parameterClass, (Object)subscriber);
        });
        this.subscriberMultiMap.asMap().values().forEach(EventBusKit::sort);
    }

    Collection<Class<?>> listEventSourceClass() {
        return this.subscriberMultiMap.keySet();
    }

    Collection<Subscriber> listSubscriber(EventBusMessage eventBusMessage) {
        Class<?> methodParamClazz = eventBusMessage.getTopicClass();
        return this.subscriberMultiMap.containsKey(methodParamClazz) ? this.subscriberMultiMap.get(methodParamClazz) : Collections.emptyList();
    }

    private Stream<Method> streamMethod(Class<?> clazz) {
        return Arrays.stream(clazz.getDeclaredMethods()).filter(method -> Objects.nonNull(method.getAnnotation(EventSubscribe.class))).filter(method -> {
            boolean result;
            boolean isPublic = Modifier.isPublic(method.getModifiers());
            boolean notStatic = !Modifier.isStatic(method.getModifiers());
            boolean onceParam = method.getParameters().length == 1;
            boolean isVoid = method.getReturnType() == Void.TYPE;
            boolean bl = result = isPublic && notStatic && onceParam && isVoid;
            if (!result) {
                log.warn("\u4e0d\u662f\u6807\u51c6\u7684\u8ba2\u9605\u65b9\u6cd5 {}", method);
            }
            return result;
        }).filter(method -> method.getParameters().length == 1);
    }
}

