/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.eventbus;

import com.iohao.game.action.skeleton.eventbus.EventBrokerClientMessage;
import com.iohao.game.action.skeleton.eventbus.EventBusMessage;
import com.iohao.game.common.kit.collect.SetMultiMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jctools.maps.NonBlockingHashMap;

final class EventBusRemoteRegion {
    static final SetMultiMap<String, EventBrokerClientMessage> remoteTopicMultiMap = SetMultiMap.create();
    static final Map<String, EventBrokerClientMessage> eventBrokerClientMessageMap = new NonBlockingHashMap();

    public static void loadRemoteEventTopic(EventBrokerClientMessage eventBrokerClientMessage) {
        Collection<String> topics = eventBrokerClientMessage.getTopics();
        topics.forEach(topic -> remoteTopicMultiMap.put(topic, (Object)eventBrokerClientMessage));
        eventBrokerClientMessageMap.put(eventBrokerClientMessage.brokerClientId, eventBrokerClientMessage);
    }

    public static void unloadRemoteTopic(EventBrokerClientMessage eventBrokerClientMessage) {
        Collection<String> topics = eventBrokerClientMessage.getTopics();
        for (String topic : topics) {
            Set eventBrokerClientMessages = remoteTopicMultiMap.get((Object)topic);
            eventBrokerClientMessages.remove(eventBrokerClientMessage);
        }
        eventBrokerClientMessageMap.remove(eventBrokerClientMessage.brokerClientId);
    }

    static Set<EventBrokerClientMessage> listRemoteEventBrokerClientMessage(EventBusMessage eventBusMessage) {
        String name = eventBusMessage.getTopic();
        return remoteTopicMultiMap.get((Object)name);
    }

    private EventBusRemoteRegion() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

