/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.eventbus;

import com.iohao.game.action.skeleton.eventbus.EventBus;
import com.iohao.game.action.skeleton.eventbus.EventBusKit;
import com.iohao.game.action.skeleton.eventbus.EventBusMessage;
import com.iohao.game.action.skeleton.eventbus.Subscriber;
import com.iohao.game.action.skeleton.eventbus.SubscriberRegistry;
import com.iohao.game.common.kit.collect.ListMultiMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.jctools.maps.NonBlockingHashMap;

final class EventBusLocalRegion {
    static final Map<String, EventBus> eventBusMap = new NonBlockingHashMap();
    static final ListMultiMap<Class<?>, Subscriber> subscriberListMap = ListMultiMap.create();

    public static EventBus getEventBus(String brokerClientId) {
        return eventBusMap.get(brokerClientId);
    }

    static boolean hasLocalNeighbor() {
        return eventBusMap.size() > 1;
    }

    static List<Subscriber> listLocalSubscriber(EventBusMessage eventBusMessage) {
        Class<?> eventSourceClazz = eventBusMessage.getTopicClass();
        return subscriberListMap.get(eventSourceClazz);
    }

    static Stream<EventBus> streamEventBus() {
        return eventBusMap.values().stream();
    }

    static void addLocal(EventBus eventBus) {
        eventBusMap.put(eventBus.id, eventBus);
        EventBusKit.executeSafe(EventBusLocalRegion::resetLocalSubscriber);
    }

    private static void resetLocalSubscriber() {
        ListMultiMap tempMultiMap = ListMultiMap.create();
        for (EventBus eventBus : eventBusMap.values()) {
            SubscriberRegistry subscriberRegistry = eventBus.subscriberRegistry;
            ListMultiMap<Class<?>, Subscriber> multiMap = subscriberRegistry.subscriberMultiMap;
            if (multiMap.isEmpty()) continue;
            for (Map.Entry entry : multiMap.entrySet()) {
                Class key = (Class)entry.getKey();
                tempMultiMap.of((Object)key).addAll((Collection)entry.getValue());
            }
        }
        subscriberListMap.clear();
        for (Map.Entry entry : tempMultiMap.entrySet()) {
            List subscribers = (List)entry.getValue();
            EventBusKit.sort(subscribers);
            subscriberListMap.of((Object)((Class)entry.getKey())).addAll(subscribers);
        }
    }

    private EventBusLocalRegion() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

