/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.eventbus;

import com.iohao.game.action.skeleton.eventbus.AnyTagBrokerClient;
import com.iohao.game.action.skeleton.eventbus.AnyTagView;
import com.iohao.game.action.skeleton.eventbus.AnyTagViewData;
import com.iohao.game.action.skeleton.eventbus.BrokerClientTag;
import com.iohao.game.action.skeleton.eventbus.EventBrokerClientMessage;
import com.iohao.game.action.skeleton.eventbus.EventBusKit;
import com.iohao.game.action.skeleton.eventbus.EventBusMessage;
import com.iohao.game.common.kit.MoreKit;
import java.util.Map;
import java.util.Objects;
import org.jctools.maps.NonBlockingHashMap;

final class EventBusAnyTagRegion {
    static Map<BrokerClientTag, AnyTagBrokerClient> map = new NonBlockingHashMap();
    static AnyTagView anyTagView = new AnyTagView();

    static AnyTagViewData getAnyTagData(EventBusMessage message) {
        return anyTagView.getAnyTagData(message);
    }

    static void add(EventBrokerClientMessage eventBrokerClientMessage) {
        BrokerClientTag tag = BrokerClientTag.of(eventBrokerClientMessage.tag);
        AnyTagBrokerClient anyTagBrokerClient = EventBusAnyTagRegion.getAnyTagBrokerClient(tag);
        anyTagBrokerClient.add(eventBrokerClientMessage);
        EventBusAnyTagRegion.reload();
    }

    static void remove(EventBrokerClientMessage eventBrokerClientMessage) {
        BrokerClientTag tag = BrokerClientTag.of(eventBrokerClientMessage.tag);
        AnyTagBrokerClient anyTagBrokerClient = EventBusAnyTagRegion.getAnyTagBrokerClient(tag);
        anyTagBrokerClient.remove(eventBrokerClientMessage);
        if (anyTagBrokerClient.isEmpty()) {
            map.remove(tag);
        }
        EventBusAnyTagRegion.reload();
    }

    private static AnyTagBrokerClient getAnyTagBrokerClient(BrokerClientTag tag) {
        AnyTagBrokerClient anyTagBrokerClient = map.get(tag);
        if (Objects.isNull(anyTagBrokerClient)) {
            AnyTagBrokerClient region = new AnyTagBrokerClient();
            return (AnyTagBrokerClient)MoreKit.firstNonNull((Object)map.putIfAbsent(tag, region), (Object)region);
        }
        return anyTagBrokerClient;
    }

    private static void reload() {
        EventBusKit.executeSafe(() -> anyTagView.reload(map.values()));
    }

    private EventBusAnyTagRegion() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

