/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.eventbus;

import com.iohao.game.action.skeleton.core.IoGameCommonCoreConfig;
import com.iohao.game.action.skeleton.core.commumication.BrokerClientContext;
import com.iohao.game.action.skeleton.eventbus.AnyTagViewData;
import com.iohao.game.action.skeleton.eventbus.EventBrokerClientMessage;
import com.iohao.game.action.skeleton.eventbus.EventBusAnyTagRegion;
import com.iohao.game.action.skeleton.eventbus.EventBusListener;
import com.iohao.game.action.skeleton.eventbus.EventBusMessage;
import com.iohao.game.action.skeleton.eventbus.EventBusMessageCreator;
import com.iohao.game.action.skeleton.eventbus.EventBusRegion;
import com.iohao.game.action.skeleton.eventbus.SubscribeExecutorStrategy;
import com.iohao.game.action.skeleton.eventbus.Subscriber;
import com.iohao.game.action.skeleton.eventbus.SubscriberInvoke;
import com.iohao.game.action.skeleton.eventbus.SubscriberInvokeCreator;
import com.iohao.game.action.skeleton.eventbus.SubscriberRegistry;
import com.iohao.game.common.kit.CollKit;
import com.iohao.game.common.kit.concurrent.executor.ExecutorRegion;
import com.iohao.game.common.kit.concurrent.executor.ThreadExecutor;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventBus {
    private static final Logger log = LoggerFactory.getLogger(EventBus.class);
    final SubscriberRegistry subscriberRegistry = new SubscriberRegistry();
    final String id;
    SubscribeExecutorStrategy subscribeExecutorStrategy;
    SubscriberInvokeCreator subscriberInvokeCreator;
    EventBusMessageCreator eventBusMessageCreator;
    EventBusListener eventBusListener;
    EventBrokerClientMessage eventBrokerClientMessage;
    BrokerClientContext brokerClientContext;
    ExecutorRegion executorRegion;
    EventBusStatus status = EventBusStatus.register;

    EventBus(String id) {
        this.id = Objects.requireNonNull(id);
    }

    public void register(Object eventBusSubscriber) {
        if (this.status != EventBusStatus.register) {
            throw new RuntimeException("\u8fd0\u884c\u4e2d\u4e0d\u5141\u8bb8\u6ce8\u518c\u8ba2\u9605\u8005\uff0c\u8bf7\u5728 AbstractEventRunner.registerEventBus \u65b9\u6cd5\u4e2d\u6ce8\u518c\u3002 ");
        }
        this.subscriberRegistry.register(eventBusSubscriber, this.subscriberInvokeCreator);
    }

    public EventBusMessage createEventBusMessage(Object eventSource) {
        return this.eventBusMessageCreator.create(eventSource);
    }

    public Set<String> listTopic() {
        return this.subscriberRegistry.listEventSourceClass().stream().map(Class::getName).collect(Collectors.toSet());
    }

    public void fire(EventBusMessage eventBusMessage) {
        this.fireLocal(eventBusMessage);
        this.fireRemote(eventBusMessage);
        if (eventBusMessage.emptyFireType()) {
            this.eventBusListener.emptySubscribe(eventBusMessage, this);
        }
    }

    public void fireSync(EventBusMessage eventBusMessage) {
        this.fireLocalSync(eventBusMessage);
        this.fireRemote(eventBusMessage);
        if (eventBusMessage.emptyFireType()) {
            this.eventBusListener.emptySubscribe(eventBusMessage, this);
        }
    }

    public void fire(Object eventSource) {
        EventBusMessage eventBusMessage = this.createEventBusMessage(eventSource);
        this.fire(eventBusMessage);
    }

    public void fireSync(Object eventSource) {
        EventBusMessage eventBusMessage = this.createEventBusMessage(eventSource);
        this.fireSync(eventBusMessage);
    }

    public void fireLocal(Object eventSource) {
        EventBusMessage eventBusMessage = this.createEventBusMessage(eventSource);
        this.fireLocal(eventBusMessage);
    }

    public void fireLocal(EventBusMessage eventBusMessage) {
        this.fireLocal(eventBusMessage, true);
    }

    public void fireLocalSync(Object eventSource) {
        EventBusMessage eventBusMessage = this.createEventBusMessage(eventSource);
        this.fireLocalSync(eventBusMessage);
    }

    public void fireLocalSync(EventBusMessage eventBusMessage) {
        this.fireLocal(eventBusMessage, false);
    }

    private void fireLocal(EventBusMessage eventBusMessage, boolean async) {
        List<Subscriber> subscribers = EventBusRegion.listLocalSubscriber(eventBusMessage);
        if (CollKit.isEmpty(subscribers)) {
            return;
        }
        eventBusMessage.addFireType(4);
        this.invokeSubscriber(eventBusMessage, async, subscribers);
    }

    void fireRemote(EventBusMessage eventBusMessage) {
        Set<EventBrokerClientMessage> messages = EventBusRegion.listRemoteEventBrokerClientMessage(eventBusMessage);
        this.fireRemote(eventBusMessage, messages);
    }

    void fireRemote(EventBusMessage eventBusMessage, Collection<EventBrokerClientMessage> messages) {
        if (CollKit.isEmpty(messages)) {
            return;
        }
        eventBusMessage.setEventBrokerClientMessages(messages);
        eventBusMessage.addFireType(8);
        this.extractedPrint(eventBusMessage);
        try {
            this.brokerClientContext.oneway(eventBusMessage);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void fireMe(Object eventSource) {
        EventBusMessage eventBusMessage = this.createEventBusMessage(eventSource);
        this.fireMe(eventBusMessage);
    }

    public void fireMe(EventBusMessage eventBusMessage) {
        this.fireMe(eventBusMessage, true);
    }

    public void fireMeSync(Object eventSource) {
        EventBusMessage eventBusMessage = this.createEventBusMessage(eventSource);
        this.fireMeSync(eventBusMessage);
    }

    public void fireMeSync(EventBusMessage eventBusMessage) {
        this.fireMe(eventBusMessage, false);
    }

    private void fireMe(EventBusMessage eventBusMessage, boolean async) {
        Collection<Subscriber> subscribers = this.listSubscriber(eventBusMessage);
        if (CollKit.isEmpty(subscribers)) {
            return;
        }
        eventBusMessage.addFireType(1);
        this.invokeSubscriber(eventBusMessage, async, subscribers);
    }

    public void fireAny(Object eventSource) {
        EventBusMessage eventBusMessage = this.createEventBusMessage(eventSource);
        this.fireAny(eventBusMessage);
    }

    public void fireAny(EventBusMessage eventBusMessage) {
        AnyTagViewData anyTagViewData = EventBusAnyTagRegion.getAnyTagData(eventBusMessage);
        List<EventBrokerClientMessage> messages = anyTagViewData.getLocalMessages();
        this.fireAny(eventBusMessage, messages, true);
        List<EventBrokerClientMessage> remoteMessages = anyTagViewData.getRemoteMessages();
        this.fireRemote(eventBusMessage, remoteMessages);
        if (eventBusMessage.emptyFireType()) {
            this.eventBusListener.emptySubscribe(eventBusMessage, this);
        }
    }

    public void fireAnySync(Object eventSource) {
        EventBusMessage eventBusMessage = this.createEventBusMessage(eventSource);
        this.fireAnySync(eventBusMessage);
    }

    public void fireAnySync(EventBusMessage eventBusMessage) {
        AnyTagViewData anyTagViewData = EventBusAnyTagRegion.getAnyTagData(eventBusMessage);
        List<EventBrokerClientMessage> messages = anyTagViewData.getLocalMessages();
        this.fireAny(eventBusMessage, messages, false);
        List<EventBrokerClientMessage> remoteMessages = anyTagViewData.getRemoteMessages();
        this.fireRemote(eventBusMessage, remoteMessages);
        if (eventBusMessage.emptyFireType()) {
            this.eventBusListener.emptySubscribe(eventBusMessage, this);
        }
    }

    void fireAny(EventBusMessage eventBusMessage, List<EventBrokerClientMessage> list, boolean async) {
        if (CollKit.isEmpty(list)) {
            return;
        }
        for (EventBrokerClientMessage brokerClientMessage : list) {
            EventBus eventBus = EventBusRegion.getEventBus(brokerClientMessage.brokerClientId);
            if (!Objects.nonNull(eventBus)) continue;
            eventBus.fireMe(eventBusMessage, async);
        }
    }

    public void fireLocalNeighbor(Object eventSource) {
        EventBusMessage eventBusMessage = this.createEventBusMessage(eventSource);
        this.fireLocalNeighbor(eventBusMessage);
    }

    public void fireLocalNeighbor(EventBusMessage eventBusMessage) {
        this.fireLocalNeighbor(eventBusMessage, true);
    }

    public void fireLocalNeighborSync(Object eventSource) {
        EventBusMessage eventBusMessage = this.createEventBusMessage(eventSource);
        this.fireLocalNeighborSync(eventBusMessage);
    }

    public void fireLocalNeighborSync(EventBusMessage eventBusMessage) {
        this.fireLocalNeighbor(eventBusMessage, false);
    }

    private void fireLocalNeighbor(EventBusMessage eventBusMessage, boolean async) {
        if (!EventBusRegion.hasLocalNeighbor()) {
            return;
        }
        List<Subscriber> subscribers = EventBusRegion.streamLocalEventBus().filter(eventBus -> !Objects.equals(this, eventBus)).flatMap(eventBus -> eventBus.listSubscriber(eventBusMessage).stream()).toList();
        if (CollKit.isEmpty(subscribers)) {
            return;
        }
        eventBusMessage.addFireType(2);
        this.invokeSubscriber(eventBusMessage, async, subscribers);
    }

    private void extractedPrint(EventBusMessage eventBusMessage) {
        if (IoGameCommonCoreConfig.eventBusLog) {
            log.info("###### \u89e6\u53d1\u8fdc\u7a0b\u903b\u8f91\u670d\u7684\u8ba2\u9605\u8005 - {} -  : {}", (Object)this.eventBrokerClientMessage.getAppName(), (Object)eventBusMessage);
            for (EventBrokerClientMessage eventBrokerClientMessage : eventBusMessage.getEventBrokerClientMessages()) {
                log.info("\u8fdc\u7a0b\u903b\u8f91\u670d : {}", (Object)eventBrokerClientMessage.getAppName());
            }
            System.out.println();
        }
    }

    private void invokeSubscriber(EventBusMessage eventBusMessage, boolean async, Collection<Subscriber> subscribers) {
        if (async) {
            for (Subscriber subscriber : subscribers) {
                ThreadExecutor threadExecutor = this.subscribeExecutorStrategy.select(subscriber, eventBusMessage, this.executorRegion);
                SubscriberInvoke subscriberInvoke = subscriber.getSubscriberInvoke();
                threadExecutor.execute(() -> this.invoke(subscriberInvoke, eventBusMessage));
            }
        } else {
            for (Subscriber subscriber : subscribers) {
                SubscriberInvoke subscriberInvoke = subscriber.getSubscriberInvoke();
                this.invoke(subscriberInvoke, eventBusMessage);
            }
        }
    }

    private void invoke(SubscriberInvoke subscriberInvoke, EventBusMessage eventBusMessage) {
        try {
            subscriberInvoke.invoke(eventBusMessage);
        }
        catch (Throwable e) {
            this.eventBusListener.invokeException(e, eventBusMessage.getEventSource(), eventBusMessage);
        }
    }

    private Collection<Subscriber> listSubscriber(EventBusMessage eventBusMessage) {
        return this.subscriberRegistry.listSubscriber(eventBusMessage);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EventBus)) {
            return false;
        }
        EventBus eventBus = (EventBus)o;
        return this.id.equals(eventBus.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public void setSubscribeExecutorStrategy(SubscribeExecutorStrategy subscribeExecutorStrategy) {
        this.subscribeExecutorStrategy = subscribeExecutorStrategy;
    }

    public void setSubscriberInvokeCreator(SubscriberInvokeCreator subscriberInvokeCreator) {
        this.subscriberInvokeCreator = subscriberInvokeCreator;
    }

    public void setEventBusMessageCreator(EventBusMessageCreator eventBusMessageCreator) {
        this.eventBusMessageCreator = eventBusMessageCreator;
    }

    public void setEventBusListener(EventBusListener eventBusListener) {
        this.eventBusListener = eventBusListener;
    }

    public void setEventBrokerClientMessage(EventBrokerClientMessage eventBrokerClientMessage) {
        this.eventBrokerClientMessage = eventBrokerClientMessage;
    }

    public void setBrokerClientContext(BrokerClientContext brokerClientContext) {
        this.brokerClientContext = brokerClientContext;
    }

    public void setExecutorRegion(ExecutorRegion executorRegion) {
        this.executorRegion = executorRegion;
    }

    public EventBusMessageCreator getEventBusMessageCreator() {
        return this.eventBusMessageCreator;
    }

    void setStatus(EventBusStatus status) {
        this.status = status;
    }

    static enum EventBusStatus {
        register,
        run;

    }
}

