/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.eventbus;

import com.iohao.game.action.skeleton.eventbus.EventBusMessage;
import com.iohao.game.action.skeleton.eventbus.ExecutorSelector;
import com.iohao.game.action.skeleton.eventbus.SubscribeExecutorStrategy;
import com.iohao.game.action.skeleton.eventbus.Subscriber;
import com.iohao.game.common.kit.concurrent.executor.ExecutorRegion;
import com.iohao.game.common.kit.concurrent.executor.ThreadExecutor;
import java.util.concurrent.atomic.AtomicLong;

final class DefaultSubscribeExecutorStrategy
implements SubscribeExecutorStrategy {
    static final AtomicLong threadIndexNo = new AtomicLong();

    DefaultSubscribeExecutorStrategy() {
    }

    @Override
    public ThreadExecutor select(Subscriber subscriber, EventBusMessage eventBusMessage, ExecutorRegion executorRegion) {
        ExecutorSelector executorSelect = subscriber.getExecutorSelect();
        if (executorSelect == ExecutorSelector.userVirtualExecutor) {
            long threadIndex = this.getThreadIndex(eventBusMessage);
            return executorRegion.getUserVirtualThreadExecutor(threadIndex);
        }
        if (executorSelect == ExecutorSelector.userExecutor) {
            long threadIndex = this.getThreadIndex(eventBusMessage);
            return executorRegion.getUserThreadExecutor(threadIndex);
        }
        if (executorSelect == ExecutorSelector.methodExecutor) {
            long threadIndex = subscriber.id;
            return executorRegion.getSimpleThreadExecutor(threadIndex);
        }
        long threadIndex = this.getThreadIndex(eventBusMessage);
        return executorRegion.getSimpleThreadExecutor(threadIndex);
    }

    long getThreadIndex(EventBusMessage eventBusMessage) {
        long userId = eventBusMessage.getThreadIndex();
        if (userId != 0L) {
            return userId;
        }
        return threadIndexNo.incrementAndGet();
    }

    static DefaultSubscribeExecutorStrategy me() {
        return Holder.ME;
    }

    private static class Holder {
        static final DefaultSubscribeExecutorStrategy ME = new DefaultSubscribeExecutorStrategy();

        private Holder() {
        }
    }
}

