/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.eventbus;

import com.iohao.game.action.skeleton.eventbus.BrokerClientId;
import com.iohao.game.action.skeleton.eventbus.EventBrokerClientMessage;
import com.iohao.game.action.skeleton.eventbus.EventBusKit;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Stream;
import org.jctools.maps.NonBlockingHashMap;

final class AnyTagBrokerClient {
    private final Map<BrokerClientId, EventBrokerClientMessage> map = new NonBlockingHashMap();
    private long nextRemote;
    private long nextLocal;
    private EventBrokerClientMessage[] eventRemoteBrokerClientMessages;
    private EventBrokerClientMessage[] eventLocalBrokerClientMessages;
    static final EventBrokerClientMessage[] emptyClientMessage = new EventBrokerClientMessage[0];

    AnyTagBrokerClient() {
    }

    boolean isEmpty() {
        return this.map.isEmpty();
    }

    Stream<EventBrokerClientMessage> streamEventBrokerClientMessage() {
        return this.map.isEmpty() ? Stream.empty() : this.map.values().stream();
    }

    void add(EventBrokerClientMessage eventBrokerClientMessage) {
        String brokerClientId = eventBrokerClientMessage.getBrokerClientId();
        BrokerClientId id = BrokerClientId.of(brokerClientId);
        this.map.put(id, eventBrokerClientMessage);
        EventBusKit.executeSafe(this::reload);
    }

    void remove(EventBrokerClientMessage eventBrokerClientMessage) {
        String brokerClientId = eventBrokerClientMessage.getBrokerClientId();
        BrokerClientId id = BrokerClientId.of(brokerClientId);
        this.map.remove(id);
        EventBusKit.executeSafe(this::reload);
    }

    EventBrokerClientMessage anyEventBrokerClientMessage() {
        int localLength = this.eventLocalBrokerClientMessages.length;
        if (localLength > 0) {
            if (localLength == 1) {
                return this.eventLocalBrokerClientMessages[0];
            }
            int index = this.getIndex(this.nextLocal++, this.eventLocalBrokerClientMessages);
            return this.eventLocalBrokerClientMessages[index];
        }
        int remoteLength = this.eventRemoteBrokerClientMessages.length;
        if (remoteLength == 1) {
            return this.eventRemoteBrokerClientMessages[0];
        }
        int index = this.getIndex(this.nextRemote++, this.eventRemoteBrokerClientMessages);
        return this.eventRemoteBrokerClientMessages[index];
    }

    private int getIndex(long index, EventBrokerClientMessage[] clientMessages) {
        return (int)(index % (long)clientMessages.length);
    }

    private void reload() {
        ArrayList<EventBrokerClientMessage> localClientMessageList = new ArrayList<EventBrokerClientMessage>();
        ArrayList<EventBrokerClientMessage> remoteClientMessageList = new ArrayList<EventBrokerClientMessage>();
        for (EventBrokerClientMessage clientMessage : this.map.values()) {
            if (clientMessage.isRemote()) {
                remoteClientMessageList.add(clientMessage);
                continue;
            }
            localClientMessageList.add(clientMessage);
        }
        this.nextRemote = 0L;
        this.nextLocal = 0L;
        this.eventLocalBrokerClientMessages = localClientMessageList.isEmpty() ? emptyClientMessage : localClientMessageList.toArray(emptyClientMessage);
        this.eventRemoteBrokerClientMessages = remoteClientMessageList.isEmpty() ? emptyClientMessage : remoteClientMessageList.toArray(emptyClientMessage);
    }
}

