/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.eventbus;

import com.iohao.game.action.skeleton.core.BarSkeleton;
import com.iohao.game.action.skeleton.core.SkeletonAttr;
import com.iohao.game.action.skeleton.core.commumication.BrokerClientContext;
import com.iohao.game.action.skeleton.core.runner.Runner;
import com.iohao.game.action.skeleton.eventbus.EventBrokerClientMessage;
import com.iohao.game.action.skeleton.eventbus.EventBus;
import com.iohao.game.action.skeleton.eventbus.EventBusListener;
import com.iohao.game.action.skeleton.eventbus.EventBusMessageCreator;
import com.iohao.game.action.skeleton.eventbus.EventBusRegion;
import com.iohao.game.action.skeleton.eventbus.EventTopicMessage;
import com.iohao.game.action.skeleton.eventbus.SubscribeExecutorStrategy;
import com.iohao.game.action.skeleton.eventbus.SubscriberInvokeCreator;
import com.iohao.game.action.skeleton.protocol.processor.SimpleServerInfo;
import java.util.Set;

public abstract class AbstractEventBusRunner
implements Runner {
    @Override
    public void onStart(BarSkeleton skeleton) {
        BrokerClientContext brokerClientContext = (BrokerClientContext)skeleton.option(SkeletonAttr.brokerClientContext);
        String brokerClientId = brokerClientContext.getId();
        EventBrokerClientMessage eventBrokerClientMessage = this.getEventBrokerClientMessage(brokerClientContext);
        EventBus eventBus = new EventBus(brokerClientId);
        skeleton.option(SkeletonAttr.eventBus, eventBus);
        eventBus.setSubscribeExecutorStrategy(SubscribeExecutorStrategy.defaultInstance());
        eventBus.setSubscriberInvokeCreator(SubscriberInvokeCreator.defaultInstance());
        eventBus.setEventBusMessageCreator(EventBusMessageCreator.defaultInstance());
        eventBus.setEventBusListener(EventBusListener.defaultInstance());
        eventBus.setExecutorRegion(skeleton.getExecutorRegion());
        eventBus.setBrokerClientContext(brokerClientContext);
        eventBus.setEventBrokerClientMessage(eventBrokerClientMessage);
        this.registerEventBus(eventBus, skeleton);
        Set<String> topic = eventBus.listTopic();
        eventBrokerClientMessage.setEventTopicMessage(new EventTopicMessage(topic));
        eventBus.setStatus(EventBus.EventBusStatus.run);
        EventBusRegion.addLocal(eventBus);
    }

    private EventBrokerClientMessage getEventBrokerClientMessage(BrokerClientContext brokerClientContext) {
        SimpleServerInfo simpleServerInfo = brokerClientContext.getSimpleServerInfo();
        String id = simpleServerInfo.getId();
        String appName = simpleServerInfo.getName();
        String tag = simpleServerInfo.getTag();
        String typeName = simpleServerInfo.getBrokerClientType();
        return new EventBrokerClientMessage(appName, tag, typeName, id);
    }

    protected abstract void registerEventBus(EventBus var1, BarSkeleton var2);
}

