/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.core.runner;

import com.iohao.game.action.skeleton.core.BarSkeleton;
import com.iohao.game.action.skeleton.core.runner.InternalRunner;
import com.iohao.game.action.skeleton.core.runner.Runner;
import com.iohao.game.common.kit.concurrent.TaskKit;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public final class Runners {
    private final List<Runner> runnerList = new CopyOnWriteArrayList<Runner>();
    private final AtomicBoolean onStart = new AtomicBoolean(false);
    private final AtomicBoolean onStartAfter = new AtomicBoolean(false);
    private BarSkeleton barSkeleton;

    public Runners() {
        InternalRunner internalRunner = new InternalRunner();
        this.runnerList.addAll(internalRunner.runnerList);
    }

    public void addRunner(Runner runner) {
        if (this.onStart.get()) {
            throw new RuntimeException("\u8fd0\u884c\u4e2d\uff0c\u4e0d\u80fd\u6dfb\u52a0 Runner \u4e86");
        }
        Objects.requireNonNull(runner);
        this.runnerList.add(runner);
    }

    public void onStart() {
        if (this.onStart.get()) {
            return;
        }
        if (this.onStart.compareAndSet(false, true)) {
            this.runnerList.forEach(runner -> runner.onStart(this.barSkeleton));
        }
    }

    public void onStartAfter() {
        if (this.onStartAfter.compareAndSet(false, true)) {
            TaskKit.newTimeout(timeout -> this.runnerList.forEach(runner -> runner.onStartAfter(this.barSkeleton)), (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    public List<String> listRunnerName() {
        return this.runnerList.stream().map(Runner::name).collect(Collectors.toList());
    }

    public void setBarSkeleton(BarSkeleton barSkeleton) {
        this.barSkeleton = barSkeleton;
    }
}

