/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.core.flow.parser;

import com.iohao.game.action.skeleton.core.ActionCommand;
import com.iohao.game.action.skeleton.core.DataCodecKit;
import com.iohao.game.action.skeleton.core.flow.parser.MethodParser;
import com.iohao.game.action.skeleton.protocol.wrapper.StringValue;
import com.iohao.game.action.skeleton.protocol.wrapper.StringValueList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

final class StringValueMethodParser
implements MethodParser {
    @Override
    public Class<?> getActualClazz(ActionCommand.MethodParamResultInfo methodParamResultInfo) {
        return methodParamResultInfo.isList() ? StringValueList.class : StringValue.class;
    }

    @Override
    public Object parseParam(byte[] data, ActionCommand.ParamInfo paramInfo) {
        if (paramInfo.isList()) {
            if (Objects.isNull(data)) {
                return Collections.emptyList();
            }
            StringValueList valueList = DataCodecKit.decode(data, StringValueList.class);
            return valueList.values;
        }
        if (Objects.isNull(data)) {
            return null;
        }
        StringValue stringValue = DataCodecKit.decode(data, StringValue.class);
        return stringValue.value;
    }

    @Override
    public Object parseResult(ActionCommand.ActionMethodReturnInfo actionMethodReturnInfo, Object methodResult) {
        if (actionMethodReturnInfo.isList()) {
            StringValueList valueList = new StringValueList();
            valueList.values = (List)methodResult;
            return valueList;
        }
        StringValue stringValue = new StringValue();
        stringValue.value = String.valueOf(methodResult);
        return stringValue;
    }

    private StringValueMethodParser() {
    }

    public static StringValueMethodParser me() {
        return Holder.ME;
    }

    private static class Holder {
        static final StringValueMethodParser ME = new StringValueMethodParser();

        private Holder() {
        }
    }
}

