/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.core.flow.parser;

import com.iohao.game.action.skeleton.core.ActionCommand;
import com.iohao.game.action.skeleton.core.flow.parser.BoolValueMethodParser;
import com.iohao.game.action.skeleton.core.flow.parser.DefaultMethodParser;
import com.iohao.game.action.skeleton.core.flow.parser.IntValueMethodParser;
import com.iohao.game.action.skeleton.core.flow.parser.LongValueMethodParser;
import com.iohao.game.action.skeleton.core.flow.parser.MethodParser;
import com.iohao.game.action.skeleton.core.flow.parser.StringValueMethodParser;
import com.iohao.game.action.skeleton.protocol.wrapper.BoolValue;
import com.iohao.game.action.skeleton.protocol.wrapper.BoolValueList;
import com.iohao.game.action.skeleton.protocol.wrapper.IntValue;
import com.iohao.game.action.skeleton.protocol.wrapper.IntValueList;
import com.iohao.game.action.skeleton.protocol.wrapper.LongValue;
import com.iohao.game.action.skeleton.protocol.wrapper.LongValueList;
import com.iohao.game.action.skeleton.protocol.wrapper.StringValue;
import com.iohao.game.action.skeleton.protocol.wrapper.StringValueList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public final class MethodParsers {
    static final Map<Class<?>, MethodParser> methodParserMap = new HashMap();
    static final Map<Class<?>, Supplier<?>> paramSupplierMap = new HashMap();
    static MethodParser methodParser = DefaultMethodParser.me();

    public static void mappingParamSupplier(Class<?> paramClass, Supplier<?> supplier) {
        paramSupplierMap.put(paramClass, supplier);
    }

    public static void mapping(Class<?> paramClass, MethodParser methodParamParser) {
        methodParserMap.put(paramClass, methodParamParser);
    }

    public static MethodParser getMethodParser(ActionCommand.ActionMethodReturnInfo actionMethodReturnInfo) {
        Class<?> methodResultClass = actionMethodReturnInfo.getActualTypeArgumentClazz();
        return MethodParsers.getMethodParser(methodResultClass);
    }

    public static MethodParser getMethodParser(ActionCommand.ParamInfo paramInfo) {
        Class<?> actualTypeArgumentClazz = paramInfo.getActualTypeArgumentClazz();
        return MethodParsers.getMethodParser(actualTypeArgumentClazz);
    }

    public static MethodParser getMethodParser(Class<?> paramClazz) {
        return methodParserMap.getOrDefault(paramClazz, methodParser);
    }

    public static void clear() {
        methodParserMap.clear();
        paramSupplierMap.clear();
    }

    public static boolean containsKey(Class<?> clazz) {
        return methodParserMap.containsKey(clazz);
    }

    public static Set<Class<?>> keySet() {
        return methodParserMap.keySet();
    }

    private static void init() {
        MethodParsers.mapping(Integer.TYPE, IntValueMethodParser.me());
        MethodParsers.mapping(Integer.class, IntValueMethodParser.me());
        MethodParsers.mapping(Long.TYPE, LongValueMethodParser.me());
        MethodParsers.mapping(Long.class, LongValueMethodParser.me());
        MethodParsers.mapping(String.class, StringValueMethodParser.me());
        MethodParsers.mapping(Boolean.TYPE, BoolValueMethodParser.me());
        MethodParsers.mapping(Boolean.class, BoolValueMethodParser.me());
        MethodParsers.mapping(IntValue.class, DefaultMethodParser.me(), IntValue::new);
        MethodParsers.mapping(IntValueList.class, DefaultMethodParser.me(), IntValueList::new);
        MethodParsers.mapping(LongValue.class, DefaultMethodParser.me(), LongValue::new);
        MethodParsers.mapping(LongValueList.class, DefaultMethodParser.me(), LongValueList::new);
        MethodParsers.mapping(BoolValue.class, DefaultMethodParser.me(), BoolValue::new);
        MethodParsers.mapping(BoolValueList.class, DefaultMethodParser.me(), BoolValueList::new);
        MethodParsers.mapping(StringValue.class, DefaultMethodParser.me(), StringValue::new);
        MethodParsers.mapping(StringValueList.class, DefaultMethodParser.me(), StringValueList::new);
    }

    static Object newObject(Class<?> paramClass) {
        if (paramSupplierMap.containsKey(paramClass)) {
            return paramSupplierMap.get(paramClass).get();
        }
        return null;
    }

    private static void mapping(Class<?> paramClass, MethodParser methodParamParser, Supplier<?> supplier) {
        MethodParsers.mapping(paramClass, methodParamParser);
        MethodParsers.mappingParamSupplier(paramClass, supplier);
    }

    private MethodParsers() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static void setMethodParser(MethodParser methodParser) {
        MethodParsers.methodParser = methodParser;
    }

    static {
        MethodParsers.init();
    }
}

