/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.core.flow.parser;

import com.iohao.game.action.skeleton.core.ActionCommand;
import com.iohao.game.action.skeleton.core.DataCodecKit;
import com.iohao.game.action.skeleton.core.flow.parser.MethodParser;
import com.iohao.game.action.skeleton.protocol.wrapper.LongValue;
import com.iohao.game.action.skeleton.protocol.wrapper.LongValueList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

final class LongValueMethodParser
implements MethodParser {
    @Override
    public Class<?> getActualClazz(ActionCommand.MethodParamResultInfo methodParamResultInfo) {
        return methodParamResultInfo.isList() ? LongValueList.class : LongValue.class;
    }

    @Override
    public Object parseParam(byte[] data, ActionCommand.ParamInfo paramInfo) {
        if (paramInfo.isList()) {
            if (Objects.isNull(data)) {
                return Collections.emptyList();
            }
            LongValueList valueList = DataCodecKit.decode(data, LongValueList.class);
            return valueList.values;
        }
        if (Objects.isNull(data)) {
            return 0L;
        }
        LongValue longValue = DataCodecKit.decode(data, LongValue.class);
        return longValue.value;
    }

    @Override
    public Object parseResult(ActionCommand.ActionMethodReturnInfo actionMethodReturnInfo, Object methodResult) {
        if (actionMethodReturnInfo.isList()) {
            LongValueList valueList = new LongValueList();
            valueList.values = (List)methodResult;
            return valueList;
        }
        LongValue longValue = new LongValue();
        longValue.value = (Long)methodResult;
        return longValue;
    }

    private LongValueMethodParser() {
    }

    public static LongValueMethodParser me() {
        return Holder.ME;
    }

    private static class Holder {
        static final LongValueMethodParser ME = new LongValueMethodParser();

        private Holder() {
        }
    }
}

