/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.core.flow.parser;

import com.iohao.game.action.skeleton.core.ActionCommand;
import com.iohao.game.action.skeleton.core.DataCodecKit;
import com.iohao.game.action.skeleton.core.flow.parser.MethodParser;
import com.iohao.game.action.skeleton.protocol.wrapper.IntValue;
import com.iohao.game.action.skeleton.protocol.wrapper.IntValueList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

final class IntValueMethodParser
implements MethodParser {
    @Override
    public Class<?> getActualClazz(ActionCommand.MethodParamResultInfo methodParamResultInfo) {
        return methodParamResultInfo.isList() ? IntValueList.class : IntValue.class;
    }

    @Override
    public Object parseParam(byte[] data, ActionCommand.ParamInfo paramInfo) {
        if (paramInfo.isList()) {
            if (Objects.isNull(data)) {
                return Collections.emptyList();
            }
            IntValueList valueList = DataCodecKit.decode(data, IntValueList.class);
            return valueList.values;
        }
        if (Objects.isNull(data)) {
            return 0;
        }
        IntValue intValue = DataCodecKit.decode(data, IntValue.class);
        return intValue.value;
    }

    @Override
    public Object parseResult(ActionCommand.ActionMethodReturnInfo actionMethodReturnInfo, Object methodResult) {
        if (actionMethodReturnInfo.isList()) {
            IntValueList valueList = new IntValueList();
            valueList.values = (List)methodResult;
            return valueList;
        }
        IntValue intValue = new IntValue();
        intValue.value = (Integer)methodResult;
        return intValue;
    }

    private IntValueMethodParser() {
    }

    public static IntValueMethodParser me() {
        return Holder.ME;
    }

    private static class Holder {
        static final IntValueMethodParser ME = new IntValueMethodParser();

        private Holder() {
        }
    }
}

