/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.core.flow.parser;

import com.iohao.game.action.skeleton.core.ActionCommand;
import com.iohao.game.action.skeleton.core.DataCodecKit;
import com.iohao.game.action.skeleton.core.flow.parser.MethodParser;
import com.iohao.game.action.skeleton.core.flow.parser.MethodParsers;
import com.iohao.game.action.skeleton.protocol.wrapper.ByteValueList;
import com.iohao.game.common.kit.CollKit;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

class DefaultMethodParser
implements MethodParser {
    @Override
    public Class<?> getActualClazz(ActionCommand.MethodParamResultInfo methodParamResultInfo) {
        return methodParamResultInfo.getActualTypeArgumentClazz();
    }

    @Override
    public Object parseParam(byte[] data, ActionCommand.ParamInfo paramInfo) {
        Object o;
        Class<?> actualTypeArgumentClazz = paramInfo.getActualTypeArgumentClazz();
        if (paramInfo.isList()) {
            if (Objects.isNull(data)) {
                return Collections.emptyList();
            }
            ByteValueList byteValueList = DataCodecKit.decode(data, ByteValueList.class);
            if (CollKit.isEmpty(byteValueList.values)) {
                return Collections.emptyList();
            }
            return byteValueList.values.stream().map(bytes -> DataCodecKit.decode(bytes, actualTypeArgumentClazz)).toList();
        }
        if (Objects.isNull(data) && Objects.nonNull(o = MethodParsers.newObject(actualTypeArgumentClazz))) {
            return o;
        }
        return DataCodecKit.decode(data, actualTypeArgumentClazz);
    }

    @Override
    public Object parseResult(ActionCommand.ActionMethodReturnInfo actionMethodReturnInfo, Object methodResult) {
        if (actionMethodReturnInfo.isList()) {
            List list = (List)methodResult;
            ByteValueList byteValueList = new ByteValueList();
            byteValueList.values = list.stream().map(DataCodecKit::encode).collect(Collectors.toList());
            return byteValueList;
        }
        return methodResult;
    }

    @Override
    public boolean isCustomMethodParser() {
        return false;
    }

    private DefaultMethodParser() {
    }

    public static DefaultMethodParser me() {
        return Holder.ME;
    }

    private static class Holder {
        static final DefaultMethodParser ME = new DefaultMethodParser();

        private Holder() {
        }
    }
}

