/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.core.flow.parser;

import com.iohao.game.action.skeleton.core.ActionCommand;
import com.iohao.game.action.skeleton.core.DataCodecKit;
import com.iohao.game.action.skeleton.core.flow.parser.MethodParser;
import com.iohao.game.action.skeleton.protocol.wrapper.BoolValue;
import com.iohao.game.action.skeleton.protocol.wrapper.BoolValueList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

final class BoolValueMethodParser
implements MethodParser {
    @Override
    public Class<?> getActualClazz(ActionCommand.MethodParamResultInfo methodParamResultInfo) {
        return methodParamResultInfo.isList() ? BoolValueList.class : BoolValue.class;
    }

    @Override
    public Object parseParam(byte[] data, ActionCommand.ParamInfo paramInfo) {
        if (paramInfo.isList()) {
            if (Objects.isNull(data)) {
                return Collections.emptyList();
            }
            BoolValueList valueList = DataCodecKit.decode(data, BoolValueList.class);
            return valueList.values;
        }
        if (Objects.isNull(data)) {
            return false;
        }
        BoolValue boolValue = DataCodecKit.decode(data, BoolValue.class);
        return boolValue.value;
    }

    @Override
    public Object parseResult(ActionCommand.ActionMethodReturnInfo actionMethodReturnInfo, Object methodResult) {
        if (actionMethodReturnInfo.isList()) {
            BoolValueList valueList = new BoolValueList();
            valueList.values = (List)methodResult;
            return valueList;
        }
        BoolValue boolValue = new BoolValue();
        boolValue.value = (Boolean)methodResult;
        return boolValue;
    }

    private BoolValueMethodParser() {
    }

    public static BoolValueMethodParser me() {
        return Holder.ME;
    }

    private static class Holder {
        static final BoolValueMethodParser ME = new BoolValueMethodParser();

        private Holder() {
        }
    }
}

