/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.core.flow.internal;

import com.iohao.game.action.skeleton.core.flow.ActionMethodInOut;
import com.iohao.game.action.skeleton.core.flow.FlowContext;
import com.iohao.game.common.kit.CollKit;
import com.iohao.game.common.kit.TimeKit;
import com.iohao.game.common.kit.concurrent.TaskKit;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BiConsumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jctools.maps.NonBlockingHashMap;

public final class TimeRangeInOut
implements ActionMethodInOut {
    final TimeRangeDayRegion region = new TimeRangeDayRegion();
    ChangeListener listener = new DefaultChangeListener();

    public void setListener(ChangeListener listener) {
        this.listener = Objects.requireNonNull(listener);
    }

    @Override
    public void fuckIn(FlowContext flowContext) {
    }

    @Override
    public void fuckOut(FlowContext flowContext) {
        LocalDate localDate = this.listener.nowLocalDate();
        LocalTime localTime = this.listener.nowLocalTime();
        this.region.update(localDate, localTime, flowContext);
    }

    public TimeRangeDayRegion getRegion() {
        return this.region;
    }

    public ChangeListener getListener() {
        return this.listener;
    }

    public class TimeRangeDayRegion {
        final Map<LocalDate, TimeRangeDay> map = new NonBlockingHashMap();

        public void forEach(BiConsumer<LocalDate, TimeRangeDay> action) {
            this.map.forEach(action);
        }

        void update(LocalDate localDate, LocalTime localTime, FlowContext flowContext) {
            TimeRangeDay timeRangeDay = this.getTimeRangeDay(localDate);
            timeRangeDay.increment(localTime);
            TimeRangeInOut.this.listener.changed(timeRangeDay, localTime, flowContext);
        }

        public TimeRangeDay getTimeRangeDay(LocalDate localDate) {
            TimeRangeDay rangeDay;
            TimeRangeDay timeRangeDay = this.map.get(localDate);
            if (Objects.isNull(timeRangeDay) && Objects.isNull(timeRangeDay = this.map.putIfAbsent(localDate, Objects.requireNonNull(rangeDay = TimeRangeInOut.this.listener.createTimeRangeDay(localDate))))) {
                timeRangeDay = this.map.get(localDate);
                TaskKit.execute(() -> {
                    LocalDate yesterdayLocalDate = localDate.minusDays(1L);
                    Optional.ofNullable(this.map.remove(yesterdayLocalDate)).ifPresent(timeRangeYesterday -> TimeRangeInOut.this.listener.callbackYesterday((TimeRangeDay)timeRangeYesterday));
                });
            }
            return timeRangeDay;
        }

        public Map<LocalDate, TimeRangeDay> getMap() {
            return this.map;
        }
    }

    private static class DefaultChangeListener
    implements ChangeListener {
        LocalDate nowLocalDate = LocalDate.now();
        LocalTime nowLocalTime = LocalTime.now();

        DefaultChangeListener() {
            TaskKit.runIntervalMinute(() -> {
                this.nowLocalDate = LocalDate.now();
                this.nowLocalTime = LocalTime.now();
            }, (long)1L);
        }

        @Override
        public LocalDate nowLocalDate() {
            return this.nowLocalDate;
        }

        @Override
        public LocalTime nowLocalTime() {
            return this.nowLocalTime;
        }
    }

    public static interface ChangeListener {
        default public void changed(TimeRangeDay timeRangeDay, LocalTime localTime, FlowContext flowContext) {
        }

        default public void callbackYesterday(TimeRangeDay timeRangeYesterday) {
        }

        default public LocalDate nowLocalDate() {
            return LocalDate.now();
        }

        default public LocalTime nowLocalTime() {
            return LocalTime.now();
        }

        default public TimeRangeDay createTimeRangeDay(LocalDate localDate) {
            List<TimeRangeHour> timeRangeHourList = this.createListenerTimeRangeHourList();
            return TimeRangeDay.create(localDate, timeRangeHourList);
        }

        default public List<TimeRangeHour> createListenerTimeRangeHourList() {
            return IntStream.range(0, 24).mapToObj(this::createListenerTimeRangeHour).toList();
        }

        default public TimeRangeHour createListenerTimeRangeHour(int hour) {
            List<TimeRangeMinute> timeRangeMinuteList = this.createListenerTimeRangeMinuteList();
            return TimeRangeHour.create(hour, timeRangeMinuteList);
        }

        default public List<TimeRangeMinute> createListenerTimeRangeMinuteList() {
            return Collections.emptyList();
        }
    }

    public record TimeRangeMinute(int start, int end, LongAdder count) {
        public static TimeRangeMinute create(int start, int end) {
            return new TimeRangeMinute(start, end, new LongAdder());
        }

        boolean inRange(int minute) {
            return minute >= this.start && minute <= this.end;
        }

        void increment() {
            this.count.increment();
        }

        @Override
        public String toString() {
            return String.format("[%d~%d\u5206\u949f %s \u6b21]", this.start, this.end, this.count);
        }
    }

    public record TimeRangeHour(LocalTime hourTime, LongAdder count, List<TimeRangeMinute> minuteList) {
        public static TimeRangeHour create(int hour, List<TimeRangeMinute> minuteList) {
            LocalTime hourTime = LocalTime.of(hour, 0);
            return new TimeRangeHour(hourTime, new LongAdder(), minuteList);
        }

        void increment(LocalTime localTime) {
            this.count.increment();
            if (CollKit.isEmpty(this.minuteList)) {
                return;
            }
            int minute = localTime.getMinute();
            this.minuteList.stream().filter(timeRangeMinute -> timeRangeMinute.inRange(minute)).findAny().ifPresent(TimeRangeMinute::increment);
        }

        public int getHour() {
            return this.hourTime.getHour();
        }

        @Override
        public String toString() {
            String hourStr = String.format("%d:00 \u5171 %s \u6b21;", this.getHour(), this.count);
            if (CollKit.isEmpty(this.minuteList)) {
                return hourStr;
            }
            StringBuilder builder = new StringBuilder();
            builder.append(hourStr);
            this.minuteList.stream().filter(timeRangeMinute -> timeRangeMinute.count.sum() > 0L).forEach(timeRangeMinute -> builder.append(" - ").append(timeRangeMinute));
            return builder.toString();
        }
    }

    public record TimeRangeDay(LocalDate localDate, LongAdder count, TimeRangeHour[] timeRangeHours) {
        public static TimeRangeDay create(LocalDate localDate, List<TimeRangeHour> timeRangeHours) {
            TimeRangeDay timeRangeDay = new TimeRangeDay(localDate, new LongAdder(), new TimeRangeHour[24]);
            for (TimeRangeHour timeRangeHour : timeRangeHours) {
                int hour = timeRangeHour.getHour();
                timeRangeDay.timeRangeHours[hour] = timeRangeHour;
            }
            return timeRangeDay;
        }

        public Stream<TimeRangeHour> stream() {
            return Arrays.stream(this.timeRangeHours).filter(Objects::nonNull);
        }

        public TimeRangeHour getTimeRangeHour(LocalTime localTime) {
            int hour = localTime.getHour();
            return this.timeRangeHours[hour];
        }

        public void increment(LocalTime localTime) {
            this.count.increment();
            TimeRangeHour timeRangeHour = this.getTimeRangeHour(localTime);
            if (Objects.nonNull(timeRangeHour)) {
                timeRangeHour.increment(localTime);
            }
        }

        @Override
        public String toString() {
            String localDateFormat = TimeKit.dateFormatterYMD.format(this.localDate);
            List<TimeRangeHour> timeRangeHoursList = this.stream().filter(timeRangeHour -> timeRangeHour.count.sum() > 0L).toList();
            if (CollKit.isEmpty(timeRangeHoursList)) {
                return localDateFormat + " action \u8c03\u7528\u6b21\u6570\u6682\u65e0\u6570\u636e";
            }
            StringBuilder builder = new StringBuilder();
            builder.append(localDateFormat).append(" action \u8c03\u7528\u6b21\u6570 \u5171 [").append(this.count).append("] \u6b21");
            for (TimeRangeHour timeRangeHour2 : timeRangeHoursList) {
                builder.append("\n\t").append(timeRangeHour2);
            }
            return builder.toString();
        }
    }
}

