/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.core.flow.internal;

import com.iohao.game.action.skeleton.core.flow.ActionMethodInOut;
import com.iohao.game.action.skeleton.core.flow.FlowContext;
import com.iohao.game.action.skeleton.core.flow.attr.FlowAttr;
import com.iohao.game.common.kit.MoreKit;
import com.iohao.game.common.kit.concurrent.executor.ThreadExecutor;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jctools.maps.NonBlockingHashMap;

public final class ThreadMonitorInOut
implements ActionMethodInOut {
    final ThreadMonitorRegion region = new ThreadMonitorRegion();

    @Override
    public void fuckIn(FlowContext flowContext) {
        flowContext.inOutStartTime();
    }

    @Override
    public void fuckOut(FlowContext flowContext) {
        ThreadExecutor threadExecutor = flowContext.option(FlowAttr.threadExecutor);
        if (Objects.nonNull(threadExecutor)) {
            this.region.update(flowContext.getInOutTime(), threadExecutor);
        }
    }

    public ThreadMonitorRegion getRegion() {
        return this.region;
    }

    public static class ThreadMonitorRegion {
        final Map<String, ThreadMonitor> map = new NonBlockingHashMap();

        private ThreadMonitor getStatThread(ThreadExecutor threadExecutor) {
            String name = threadExecutor.name();
            ThreadMonitor threadMonitor = this.map.get(name);
            if (Objects.isNull(threadMonitor)) {
                ThreadMonitor newValue = ThreadMonitor.create(name, threadExecutor);
                return (ThreadMonitor)MoreKit.putIfAbsent(this.map, (Object)name, (Object)newValue);
            }
            return threadMonitor;
        }

        void update(long time, ThreadExecutor threadExecutor) {
            this.getStatThread(threadExecutor).increment(time);
        }

        public void forEach(Consumer<ThreadMonitor> action) {
            this.map.values().stream().filter(ThreadMonitor::notEmpty).forEach(action);
        }

        public String toString() {
            TreeMap<String, ThreadMonitor> sortMap = new TreeMap<String, ThreadMonitor>(this.map);
            return sortMap.values().stream().filter(ThreadMonitor::notEmpty).map(ThreadMonitor::toString).collect(Collectors.joining("\n"));
        }

        public Map<String, ThreadMonitor> getMap() {
            return this.map;
        }
    }

    public record ThreadMonitor(String name, LongAdder executeCount, LongAdder totalTime, ThreadExecutor executor) {
        public static ThreadMonitor create(String name, ThreadExecutor executor) {
            return new ThreadMonitor(name, new LongAdder(), new LongAdder(), executor);
        }

        void increment(long time) {
            this.executeCount.increment();
            this.totalTime.add(time);
        }

        boolean notEmpty() {
            return this.executeCount.sum() > 0L;
        }

        public long getAvgTime() {
            return this.totalTime.sum() / this.executeCount.sum();
        }

        public int countRemaining() {
            return Optional.ofNullable(this.executor).map(ThreadExecutor::getWorkQueue).orElse(0);
        }

        @Override
        public String toString() {
            return String.format("\u4e1a\u52a1\u7ebf\u7a0b[%s] \u5171\u6267\u884c\u4e86 %s \u6b21\u4e1a\u52a1\uff0c\u5e73\u5747\u8017\u65f6 %d ms, \u5269\u4f59 %d \u4e2a\u4efb\u52a1\u672a\u6267\u884c", this.name, this.executeCount, this.getAvgTime(), this.countRemaining());
        }
    }
}

