/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.core.flow.internal;

import com.iohao.game.action.skeleton.core.CmdInfo;
import com.iohao.game.action.skeleton.core.CmdKit;
import com.iohao.game.action.skeleton.core.flow.ActionMethodInOut;
import com.iohao.game.action.skeleton.core.flow.FlowContext;
import com.iohao.game.common.kit.CollKit;
import com.iohao.game.common.kit.MoreKit;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jctools.maps.NonBlockingHashMap;

public final class StatActionInOut
implements ActionMethodInOut {
    final StatActionRegion region = new StatActionRegion();
    StatActionChangeListener listener;

    @Override
    public void fuckIn(FlowContext flowContext) {
        flowContext.inOutStartTime();
    }

    @Override
    public void fuckOut(FlowContext flowContext) {
        long time = flowContext.getInOutTime();
        this.region.update(time, flowContext);
    }

    public StatActionRegion getRegion() {
        return this.region;
    }

    public void setListener(StatActionChangeListener listener) {
        this.listener = listener;
    }

    public final class StatActionRegion {
        final Map<CmdInfo, StatAction> map = new NonBlockingHashMap();

        void update(long time, FlowContext flowContext) {
            CmdInfo cmdInfo = flowContext.getCmdInfo();
            StatAction statAction = this.getStatAction(cmdInfo);
            statAction.update(flowContext, time);
            if (Objects.nonNull(StatActionInOut.this.listener)) {
                StatActionInOut.this.listener.flow(statAction, time, flowContext);
            }
        }

        public StatAction getStatAction(CmdInfo cmdInfo) {
            StatAction statAction = this.map.get(cmdInfo);
            if (Objects.isNull(statAction)) {
                StatAction newValue = new StatAction(cmdInfo);
                return (StatAction)MoreKit.putIfAbsent(this.map, (Object)cmdInfo, (Object)newValue);
            }
            return statAction;
        }

        public void forEach(BiConsumer<CmdInfo, StatAction> action) {
            this.map.forEach(action);
        }

        public Stream<StatAction> stream() {
            return this.map.values().stream();
        }

        public String toString() {
            return this.map.values().stream().map(StatAction::toString).collect(Collectors.joining("\n"));
        }
    }

    public static interface StatActionChangeListener {
        public void changed(StatAction var1, long var2, FlowContext var4);

        default public List<TimeRange> createTimeRangeList() {
            return List.of(TimeRange.create(500L, 1000L), TimeRange.create(1000L, 1500L), TimeRange.create(1500L, 2000L), TimeRange.create(2000L, Long.MAX_VALUE, "> 2000"));
        }

        default public boolean triggerUpdateTimeRange(StatAction statAction, long time, FlowContext flowContext) {
            return false;
        }

        default public void updateTimeRange(StatAction statAction, long time, FlowContext flowContext) {
            statAction.getTimeRange(time).increment();
        }

        default public void flow(StatAction statAction, long time, FlowContext flowContext) {
            if (this.triggerUpdateTimeRange(statAction, time, flowContext)) {
                this.updateTimeRange(statAction, time, flowContext);
            }
            this.changed(statAction, time, flowContext);
        }
    }

    public record TimeRange(long start, long end, LongAdder count, String name) {
        public static TimeRange create(long start, long end) {
            return TimeRange.create(start, end, start + " ~ " + end);
        }

        public static TimeRange create(long start, long end, String name) {
            return new TimeRange(start, end, new LongAdder(), name);
        }

        boolean inRange(long time) {
            return time >= this.start && time <= this.end;
        }

        void increment() {
            this.count.increment();
        }

        @Override
        public String toString() {
            return String.format("%s ms \u7684\u8bf7\u6c42\u5171 [%d] \u4e2a", this.name, this.count.sum());
        }
    }

    public final class StatAction {
        static final List<TimeRange> emptyRangeList = List.of(TimeRange.create(0x7FFFFFFFFFFFFFFEL, Long.MAX_VALUE, ""));
        final List<TimeRange> timeRangeList;
        final TimeRange lastTimeRange;
        final CmdInfo cmdInfo;
        final LongAdder executeCount = new LongAdder();
        final LongAdder totalTime = new LongAdder();
        final LongAdder errorCount = new LongAdder();
        volatile long maxTime;

        private StatAction(CmdInfo cmdInfo) {
            List<TimeRange> list = this.timeRangeList = Objects.isNull(StatActionInOut.this.listener) ? emptyRangeList : StatActionInOut.this.listener.createTimeRangeList();
            if (CollKit.isEmpty(this.timeRangeList)) {
                throw new IllegalArgumentException("this.timeRangeList is empty");
            }
            this.cmdInfo = cmdInfo;
            this.lastTimeRange = this.timeRangeList.getLast();
        }

        private void update(FlowContext flowContext, long time) {
            this.executeCount.increment();
            if (flowContext.isError()) {
                this.errorCount.increment();
            }
            if (time == 0L) {
                return;
            }
            this.totalTime.add(time);
            if (time > this.maxTime) {
                this.maxTime = time;
            }
        }

        public TimeRange getTimeRange(long time) {
            return this.timeRangeList.stream().filter(timeRange -> timeRange.inRange(time)).findFirst().orElse(this.lastTimeRange);
        }

        public long getAvgTime() {
            return this.totalTime.sum() / this.executeCount.sum();
        }

        public String toString() {
            String rangeStr = "";
            if (Objects.nonNull(StatActionInOut.this.listener)) {
                StringBuilder builder = new StringBuilder();
                for (TimeRange timeRange : this.timeRangeList) {
                    if (timeRange.count.sum() == 0L) continue;
                    builder.append("\n\t").append(timeRange);
                }
                rangeStr = builder.toString();
            }
            return String.format("%s, \u6267\u884c[%s]\u6b21, \u5f02\u5e38[%s]\u6b21, \u5e73\u5747\u8017\u65f6[%d], \u6700\u5927\u8017\u65f6[%s], \u603b\u8017\u65f6[%s] %s", CmdKit.toString(this.cmdInfo.getCmdMerge()), this.executeCount, this.errorCount, this.getAvgTime(), this.maxTime, this.totalTime, rangeStr);
        }

        public List<TimeRange> getTimeRangeList() {
            return this.timeRangeList;
        }

        public CmdInfo getCmdInfo() {
            return this.cmdInfo;
        }

        public LongAdder getExecuteCount() {
            return this.executeCount;
        }

        public LongAdder getTotalTime() {
            return this.totalTime;
        }

        public LongAdder getErrorCount() {
            return this.errorCount;
        }

        public long getMaxTime() {
            return this.maxTime;
        }

        private TimeRange getLastTimeRange() {
            return this.lastTimeRange;
        }
    }
}

