/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.core.flow.internal;

import com.iohao.game.action.skeleton.core.ActionCommand;
import com.iohao.game.action.skeleton.core.ValidatorKit;
import com.iohao.game.action.skeleton.core.exception.ActionErrorEnum;
import com.iohao.game.action.skeleton.core.flow.ActionMethodParamParser;
import com.iohao.game.action.skeleton.core.flow.FlowContext;
import com.iohao.game.action.skeleton.core.flow.attr.FlowAttr;
import com.iohao.game.action.skeleton.core.flow.parser.MethodParser;
import com.iohao.game.action.skeleton.core.flow.parser.MethodParsers;
import com.iohao.game.action.skeleton.protocol.RequestMessage;
import com.iohao.game.action.skeleton.protocol.ResponseMessage;
import java.util.Objects;

public final class DefaultActionMethodParamParser
implements ActionMethodParamParser {
    @Override
    public Object[] listParam(FlowContext flowContext) {
        ActionCommand actionCommand = flowContext.getActionCommand();
        if (!actionCommand.isMethodHasParam()) {
            return METHOD_PARAMS;
        }
        RequestMessage request = flowContext.getRequest();
        ResponseMessage response = flowContext.getResponse();
        ActionCommand.ParamInfo[] paramInfos = actionCommand.getParamInfos();
        int len = paramInfos.length;
        Object[] params = new Object[len];
        for (int i = 0; i < len; ++i) {
            Object param;
            ActionCommand.ParamInfo paramInfo = paramInfos[i];
            if (paramInfo.isFlowContext()) {
                params[i] = flowContext;
                continue;
            }
            Class<?> paramClazz = paramInfo.getActualTypeArgumentClazz();
            MethodParser methodParser = MethodParsers.getMethodParser(paramClazz);
            params[i] = param = methodParser.parseParam(request.getData(), paramInfo);
            flowContext.option(FlowAttr.actionBizParam, param);
            if (!paramInfo.isValidator()) continue;
            DefaultActionMethodParamParser.extractedValidator(response, paramInfo, param);
        }
        return params;
    }

    private static void extractedValidator(ResponseMessage response, ActionCommand.ParamInfo paramInfo, Object param) {
        Class<?>[] groups = paramInfo.getValidatorGroups();
        String validateMsg = ValidatorKit.validate(param, groups);
        if (Objects.nonNull(validateMsg)) {
            response.setValidatorMsg(validateMsg);
            response.setResponseStatus(ActionErrorEnum.validateErrCode.getCode());
        }
    }
}

