/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.core.flow.internal;

import com.iohao.game.action.skeleton.IoGameVersion;
import com.iohao.game.action.skeleton.core.ActionCommand;
import com.iohao.game.action.skeleton.core.CmdInfo;
import com.iohao.game.action.skeleton.core.CmdKit;
import com.iohao.game.action.skeleton.core.DataCodecKit;
import com.iohao.game.action.skeleton.core.doc.ActionCommandDoc;
import com.iohao.game.action.skeleton.core.flow.ActionMethodInOut;
import com.iohao.game.action.skeleton.core.flow.FlowContext;
import com.iohao.game.action.skeleton.core.flow.attr.FlowAttr;
import com.iohao.game.action.skeleton.protocol.HeadMetadata;
import com.iohao.game.action.skeleton.protocol.ResponseMessage;
import com.iohao.game.action.skeleton.protocol.wrapper.ByteValueList;
import com.iohao.game.common.kit.CollKit;
import com.iohao.game.common.kit.StrKit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;

public final class DebugInOut
implements ActionMethodInOut {
    final long time;
    BiConsumer<String, FlowContext> printConsumer = (message, flowContext) -> System.out.println((String)message);

    public DebugInOut() {
        this(0L);
    }

    public DebugInOut(long time) {
        this.time = time;
    }

    @Override
    public void fuckIn(FlowContext flowContext) {
        flowContext.inOutStartTime();
    }

    @Override
    public void fuckOut(FlowContext flowContext) {
        long ms = flowContext.getInOutTime();
        if (this.time > ms) {
            return;
        }
        ActionCommand actionCommand = flowContext.getActionCommand();
        ActionCommandDoc actionCommandDoc = actionCommand.getActionCommandDoc();
        Class<?> cc = actionCommand.getActionControllerClazz();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("ioGameVersion", IoGameVersion.VERSION);
        paramMap.put("threadName", Thread.currentThread().getName());
        paramMap.put("className", cc.getSimpleName());
        paramMap.put("actionMethodName", actionCommand.getActionMethodName());
        paramMap.put("time", ms);
        paramMap.put("lineNumber", actionCommandDoc.getLineNumber());
        CmdInfo cmdInfo = flowContext.getRequest().getHeadMetadata().getCmdInfo();
        paramMap.put("cmdInfo", CmdKit.mergeToShort(cmdInfo.getCmdMerge()));
        paramMap.put("userId", flowContext.getUserId());
        paramMap.put("paramName", "");
        paramMap.put("paramData", "");
        paramMap.put("returnData", "");
        paramMap.put("logicServerId", flowContext.option(FlowAttr.logicServerId));
        paramMap.put("logicServerTag", flowContext.option(FlowAttr.logicServerTag));
        DebugInOut.extractedJoin(flowContext, paramMap);
        DebugInOut.extractedTraceId(flowContext, paramMap);
        this.methodRequestParam(flowContext, paramMap);
        ResponseMessage responseMessage = flowContext.getResponse();
        if (responseMessage.hasError()) {
            this.printValidate(flowContext, paramMap);
        } else {
            this.printNormal(flowContext, paramMap);
        }
    }

    private static void extractedTraceId(FlowContext flowContext, Map<String, Object> paramMap) {
        HeadMetadata headMetadata = flowContext.getHeadMetadata();
        String traceId = headMetadata.getTraceId();
        if (Objects.isNull(traceId)) {
            paramMap.put("traceId", "");
            return;
        }
        String str = String.format(" [traceId:%s] ", traceId);
        paramMap.put("traceId", str);
    }

    private static void extractedJoin(FlowContext flowContext, Map<String, Object> paramMap) {
        HeadMetadata headMetadata = flowContext.getHeadMetadata();
        int stick = headMetadata.getStick();
        String str = switch (stick) {
            case 1 -> " [\u8fde\u63a5\u65b9\u5f0f:TCP] ";
            case 2 -> " [\u8fde\u63a5\u65b9\u5f0f:WebSocket] ";
            case 3 -> " [\u8fde\u63a5\u65b9\u5f0f:UDP] ";
            default -> "";
        };
        paramMap.put("joinName", str);
    }

    private void printValidate(FlowContext flowContext, Map<String, Object> paramMap) {
        ResponseMessage responseMessage = flowContext.getResponse();
        paramMap.put("errorCode", responseMessage.getResponseStatus());
        paramMap.put("validatorMsg", responseMessage.getValidatorMsg());
        if (StrKit.isEmpty((String)responseMessage.getValidatorMsg())) {
            paramMap.put("validatorMsg", flowContext.option(FlowAttr.msgException));
        }
        String template = "\u250f\u2501\u2501\u9519\u8bef\u2501\u2501\u2501 Debug. [({className}.java:{lineNumber}).{actionMethodName}] \u2501\u2501\u2501 {cmdInfo} \u2501\u2501\u2501 [{logicServerTag}] \u2501\u2501\u2501 [id:{logicServerId}]\n\u2523 userId: {userId}\n\u2523 \u53c2\u6570: {paramName} : {paramData}\n\u2523 \u9519\u8bef\u7801: {errorCode}\n\u2523 \u9519\u8bef\u4fe1\u606f: {validatorMsg}\n\u2523 \u65f6\u95f4: {time} ms (\u4e1a\u52a1\u65b9\u6cd5\u603b\u8017\u65f6)\n\u2517\u2501\u2501\u2501\u2501\u2501 [ioGame:{ioGameVersion}] \u2501\u2501\u2501\u2501\u2501 [\u7ebf\u7a0b:{threadName}] \u2501\u2501\u2501\u2501\u2501{joinName}\u2501\u2501\u2501\u2501\u2501{traceId}\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\n";
        String message = StrKit.format((CharSequence)template, paramMap);
        this.printConsumer.accept(message, flowContext);
    }

    private void printNormal(FlowContext flowContext, Map<String, Object> paramMap) {
        this.methodResponseData(flowContext, paramMap);
        ActionCommand actionCommand = flowContext.getActionCommand();
        if (actionCommand.getActionMethodReturnInfo().isVoid()) {
            paramMap.put("returnData", "void");
        }
        String template = "\u250f\u2501\u2501\u2501\u2501\u2501 Debug. [({className}.java:{lineNumber}).{actionMethodName}] \u2501\u2501\u2501\u2501\u2501 {cmdInfo} \u2501\u2501\u2501\u2501\u2501 [{logicServerTag}] \u2501\u2501\u2501\u2501\u2501 [id:{logicServerId}]\n\u2523 userId: {userId}\n\u2523 \u53c2\u6570: {paramName} : {paramData}\n\u2523 \u54cd\u5e94: {returnData}\n\u2523 \u65f6\u95f4: {time} ms (\u4e1a\u52a1\u65b9\u6cd5\u603b\u8017\u65f6)\n\u2517\u2501\u2501\u2501\u2501\u2501 [ioGame:{ioGameVersion}] \u2501\u2501\u2501\u2501\u2501 [\u7ebf\u7a0b:{threadName}] \u2501\u2501\u2501\u2501\u2501{joinName}\u2501\u2501\u2501\u2501\u2501{traceId}\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\n";
        String message = StrKit.format((CharSequence)template, paramMap);
        this.printConsumer.accept(message, flowContext);
    }

    private void methodResponseData(FlowContext flowContext, Map<String, Object> paramMap) {
        List<Object> data = flowContext.getMethodResult();
        if (Objects.isNull(data)) {
            data = "null";
        }
        if (data instanceof ByteValueList) {
            ByteValueList byteValueList = (ByteValueList)((Object)data);
            if (CollKit.notEmpty(byteValueList.values)) {
                ActionCommand actionCommand = flowContext.getActionCommand();
                ActionCommand.ActionMethodReturnInfo actionMethodReturnInfo = actionCommand.getActionMethodReturnInfo();
                Class<?> actualTypeArgumentClazz = actionMethodReturnInfo.getActualTypeArgumentClazz();
                data = byteValueList.values.stream().map(bytes -> DataCodecKit.decode(bytes, actualTypeArgumentClazz)).toList();
            }
        }
        paramMap.put("returnData", data);
    }

    private void methodRequestParam(FlowContext flowContext, Map<String, Object> paramMap) {
        ActionCommand.ParamInfo[] paramInfos;
        ActionCommand actionCommand = flowContext.getActionCommand();
        if (!actionCommand.isMethodHasParam()) {
            return;
        }
        for (ActionCommand.ParamInfo paramInfo : paramInfos = actionCommand.getParamInfos()) {
            Class<?> paramClazz = paramInfo.getParamClazz();
            if (FlowContext.class.isAssignableFrom(paramClazz)) continue;
            paramMap.put("paramName", paramInfo.getName());
            Object bizData = flowContext.option(FlowAttr.actionBizParam);
            if (Objects.isNull(bizData)) {
                bizData = "null";
            }
            paramMap.put("paramData", bizData);
        }
    }

    public void setPrintConsumer(BiConsumer<String, FlowContext> printConsumer) {
        this.printConsumer = printConsumer;
    }
}

