/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.core.flow;

import com.iohao.game.action.skeleton.core.flow.InternalFlowContextKit;
import com.iohao.game.action.skeleton.core.flow.SimpleCommon;
import com.iohao.game.action.skeleton.kit.ExecutorSelectKit;
import com.iohao.game.action.skeleton.protocol.HeadMetadata;
import com.iohao.game.common.kit.concurrent.executor.ExecutorRegion;
import com.iohao.game.common.kit.concurrent.executor.ThreadExecutor;
import java.util.Objects;
import java.util.concurrent.Executor;

interface SimpleExecutor
extends SimpleCommon {
    default public ExecutorRegion getExecutorRegion() {
        return this.getBarSkeleton().getExecutorRegion();
    }

    default public Executor getVirtualExecutor() {
        HeadMetadata headMetadata = this.getHeadMetadata();
        long executorIndex = ExecutorSelectKit.getExecutorIndex(headMetadata);
        ExecutorRegion executorRegion = this.getExecutorRegion();
        ThreadExecutor threadExecutor = executorRegion.getUserVirtualThreadExecutor(executorIndex);
        return threadExecutor.executor();
    }

    default public Executor getExecutor() {
        HeadMetadata headMetadata = this.getHeadMetadata();
        long executorIndex = ExecutorSelectKit.getExecutorIndex(headMetadata);
        ExecutorRegion executorRegion = this.getExecutorRegion();
        ThreadExecutor threadExecutor = executorRegion.getUserThreadExecutor(executorIndex);
        return threadExecutor.executor();
    }

    default public void execute(Runnable command) {
        HeadMetadata headMetadata = this.getHeadMetadata();
        String traceId = headMetadata.getTraceId();
        if (Objects.isNull(traceId)) {
            this.getExecutor().execute(command);
            return;
        }
        this.getExecutor().execute(InternalFlowContextKit.decorator(traceId, command));
    }

    default public void executeVirtual(Runnable command) {
        HeadMetadata headMetadata = this.getHeadMetadata();
        String traceId = headMetadata.getTraceId();
        if (Objects.isNull(traceId)) {
            this.getVirtualExecutor().execute(command);
            return;
        }
        this.getVirtualExecutor().execute(InternalFlowContextKit.decorator(traceId, command));
    }
}

