/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.core.flow;

import com.iohao.game.action.skeleton.core.BarMessageKit;
import com.iohao.game.action.skeleton.core.CmdInfo;
import com.iohao.game.action.skeleton.core.commumication.BroadcastContext;
import com.iohao.game.action.skeleton.core.commumication.BroadcastOrderContext;
import com.iohao.game.action.skeleton.core.flow.SimpleCommunication;
import com.iohao.game.action.skeleton.protocol.HeadMetadata;
import com.iohao.game.action.skeleton.protocol.ResponseMessage;
import java.util.Collection;
import java.util.Objects;

interface SimpleCommunicationBroadcast
extends SimpleCommunication {
    private void employTraceId(ResponseMessage responseMessage) {
        String traceId = this.getHeadMetadata().getTraceId();
        if (Objects.nonNull(traceId)) {
            HeadMetadata headMetadata = responseMessage.getHeadMetadata();
            headMetadata.setTraceId(traceId);
        }
    }

    private void extractedSourceClientId(ResponseMessage responseMessage, long userId) {
        HeadMetadata responseMessageHeadMetadata = responseMessage.getHeadMetadata();
        if (responseMessageHeadMetadata.getSourceClientId() != 0) {
            return;
        }
        HeadMetadata headMetadata = this.getHeadMetadata();
        if (userId != headMetadata.getUserId()) {
            return;
        }
        int sourceClientId = headMetadata.getSourceClientId();
        responseMessageHeadMetadata.setSourceClientId(sourceClientId);
    }

    default public void broadcastMe(Object bizData) {
        HeadMetadata headMetadata = this.getHeadMetadata();
        CmdInfo cmdInfo = headMetadata.getCmdInfo();
        this.broadcastMe(cmdInfo, bizData);
    }

    default public void broadcastMe(CmdInfo cmdInfo, Object bizData) {
        ResponseMessage responseMessage = this.createResponseMessage(cmdInfo, bizData);
        this.broadcastMe(responseMessage);
    }

    default public void broadcastMe(ResponseMessage responseMessage) {
        long userId = this.getUserId();
        this.broadcast(responseMessage, userId);
    }

    default public void broadcast(CmdInfo cmdInfo, Object bizData) {
        ResponseMessage responseMessage = BarMessageKit.createResponseMessage(cmdInfo, bizData);
        this.broadcast(responseMessage);
    }

    default public void broadcast(ResponseMessage responseMessage) {
        this.employTraceId(responseMessage);
        BroadcastContext broadcastContext = this.getBroadcastContext();
        broadcastContext.broadcast(responseMessage);
    }

    default public void broadcast(CmdInfo cmdInfo, Object bizData, long userId) {
        ResponseMessage responseMessage = BarMessageKit.createResponseMessage(cmdInfo, bizData);
        this.broadcast(responseMessage, userId);
    }

    default public void broadcast(ResponseMessage responseMessage, long userId) {
        this.employTraceId(responseMessage);
        this.extractedSourceClientId(responseMessage, userId);
        BroadcastContext broadcastContext = this.getBroadcastContext();
        broadcastContext.broadcast(responseMessage, userId);
    }

    default public void broadcast(CmdInfo cmdInfo, Object bizData, Collection<Long> userIdList) {
        ResponseMessage responseMessage = BarMessageKit.createResponseMessage(cmdInfo, bizData);
        this.broadcast(responseMessage, userIdList);
    }

    default public void broadcast(ResponseMessage responseMessage, Collection<Long> userIdList) {
        this.employTraceId(responseMessage);
        BroadcastContext broadcastContext = this.getBroadcastContext();
        broadcastContext.broadcast(responseMessage, userIdList);
    }

    default public void broadcastOrderMe(Object bizData) {
        HeadMetadata headMetadata = this.getHeadMetadata();
        CmdInfo cmdInfo = headMetadata.getCmdInfo();
        this.broadcastOrderMe(cmdInfo, bizData);
    }

    default public void broadcastOrderMe(CmdInfo cmdInfo, Object bizData) {
        ResponseMessage responseMessage = this.createResponseMessage(cmdInfo, bizData);
        this.broadcastOrderMe(responseMessage);
    }

    default public void broadcastOrderMe(ResponseMessage responseMessage) {
        long userId = this.getUserId();
        this.broadcastOrder(responseMessage, userId);
    }

    default public void broadcastOrder(CmdInfo cmdInfo, Object bizData) {
        ResponseMessage responseMessage = BarMessageKit.createResponseMessage(cmdInfo, bizData);
        this.broadcastOrder(responseMessage);
    }

    default public void broadcastOrder(ResponseMessage responseMessage) {
        this.employTraceId(responseMessage);
        BroadcastOrderContext broadcastOrderContext = this.getBroadcastOrderContext();
        broadcastOrderContext.broadcastOrder(responseMessage);
    }

    default public void broadcastOrder(CmdInfo cmdInfo, Object bizData, Collection<Long> userIdList) {
        ResponseMessage responseMessage = BarMessageKit.createResponseMessage(cmdInfo, bizData);
        this.broadcastOrder(responseMessage, userIdList);
    }

    default public void broadcastOrder(ResponseMessage responseMessage, Collection<Long> userIdList) {
        this.employTraceId(responseMessage);
        BroadcastOrderContext broadcastOrderContext = this.getBroadcastOrderContext();
        broadcastOrderContext.broadcastOrder(responseMessage, userIdList);
    }

    default public void broadcastOrder(CmdInfo cmdInfo, Object bizData, long userId) {
        ResponseMessage responseMessage = BarMessageKit.createResponseMessage(cmdInfo, bizData);
        this.broadcastOrder(responseMessage, userId);
    }

    default public void broadcastOrder(ResponseMessage responseMessage, long userId) {
        this.employTraceId(responseMessage);
        this.extractedSourceClientId(responseMessage, userId);
        BroadcastOrderContext broadcastOrderContext = this.getBroadcastOrderContext();
        broadcastOrderContext.broadcastOrder(responseMessage, userId);
    }
}

