/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.core.flow;

import java.util.function.Consumer;
import org.slf4j.MDC;

final class InternalFlowContextKit {
    static <T> void decorate(String traceId, Consumer<T> callback, T response) {
        try {
            MDC.put((String)"ioGameTraceId", (String)traceId);
            callback.accept(response);
        }
        finally {
            MDC.clear();
        }
    }

    static Runnable decorator(String traceId, Runnable command) {
        return () -> {
            try {
                MDC.put((String)"ioGameTraceId", (String)traceId);
                command.run();
            }
            finally {
                MDC.clear();
            }
        };
    }

    private InternalFlowContextKit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

