/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.core.flow;

import com.iohao.game.action.skeleton.core.ActionCommand;
import com.iohao.game.action.skeleton.core.ActionCommandRegions;
import com.iohao.game.action.skeleton.core.BarSkeleton;
import com.iohao.game.action.skeleton.core.commumication.ChannelContext;
import com.iohao.game.action.skeleton.core.flow.FlowContext;
import com.iohao.game.action.skeleton.core.flow.ResponseMessageCreate;
import com.iohao.game.action.skeleton.core.flow.attr.FlowAttr;
import com.iohao.game.action.skeleton.protocol.HeadMetadata;
import com.iohao.game.action.skeleton.protocol.RequestMessage;
import com.iohao.game.action.skeleton.protocol.ResponseMessage;
import java.util.Objects;

public final class FlowContextKit {
    static final byte REQUEST_ONEWAY = 2;

    public static void employ(FlowContext flowContext) {
        BarSkeleton barSkeleton = flowContext.getBarSkeleton();
        RequestMessage request = flowContext.getRequest();
        HeadMetadata headMetadata = request.getHeadMetadata();
        if (Objects.isNull(flowContext.getActionCommand())) {
            int cmdMerge = headMetadata.getCmdMerge();
            ActionCommandRegions actionCommandRegions = barSkeleton.getActionCommandRegions();
            ActionCommand actionCommand = actionCommandRegions.getActionCommand(cmdMerge);
            flowContext.setActionCommand(actionCommand);
        }
        if (Objects.isNull(flowContext.getResponse())) {
            ResponseMessageCreate responseMessageCreate = barSkeleton.getResponseMessageCreate();
            ResponseMessage responseMessage = responseMessageCreate.createResponseMessage();
            request.settingCommonAttr(responseMessage);
            flowContext.setResponse(responseMessage);
        }
    }

    public static ChannelContext getChannelContext(FlowContext flowContext) {
        ResponseMessage response = flowContext.getResponse();
        HeadMetadata headMetadata = response.getHeadMetadata();
        byte rpcCommandType = headMetadata.getRpcCommandType();
        if (rpcCommandType == 2) {
            return flowContext.option(FlowAttr.brokerClientContext);
        }
        return flowContext.option(FlowAttr.channelContext);
    }

    private FlowContextKit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

