/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.core.flow;

import com.iohao.game.action.skeleton.core.ActionCommand;
import com.iohao.game.action.skeleton.core.BarSkeleton;
import com.iohao.game.action.skeleton.core.flow.SimpleContext;
import com.iohao.game.action.skeleton.core.flow.attr.FlowOption;
import com.iohao.game.action.skeleton.protocol.HeadMetadata;
import com.iohao.game.action.skeleton.protocol.RequestMessage;
import com.iohao.game.action.skeleton.protocol.ResponseMessage;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class FlowContext
implements SimpleContext {
    private final Map<FlowOption<?>, Object> options = new HashMap();
    private BarSkeleton barSkeleton;
    private ActionCommand actionCommand;
    private Object actionController;
    private RequestMessage request;
    private ResponseMessage response;
    private Object[] methodParams;
    private Object methodResult;
    private boolean error;
    private boolean executeActionAfter = true;
    private long inOutStartTime;
    private long inOutTime;

    public FlowContext setMethodResult(Object methodResult) {
        if (Objects.nonNull(methodResult)) {
            this.methodResult = methodResult;
        }
        return this;
    }

    @Override
    public HeadMetadata getHeadMetadata() {
        return this.request.getHeadMetadata();
    }

    public void inOutStartTime() {
        if (this.inOutStartTime == 0L) {
            this.inOutStartTime = System.currentTimeMillis();
        }
    }

    public long getInOutTime() {
        if (this.inOutStartTime == 0L) {
            return Long.MAX_VALUE;
        }
        if (this.inOutTime == 0L) {
            this.inOutTime = System.currentTimeMillis() - this.inOutStartTime;
        }
        return this.inOutTime;
    }

    public FlowContext setBarSkeleton(BarSkeleton barSkeleton) {
        this.barSkeleton = barSkeleton;
        return this;
    }

    public FlowContext setActionCommand(ActionCommand actionCommand) {
        this.actionCommand = actionCommand;
        return this;
    }

    public FlowContext setActionController(Object actionController) {
        this.actionController = actionController;
        return this;
    }

    public FlowContext setRequest(RequestMessage request) {
        this.request = request;
        return this;
    }

    public FlowContext setResponse(ResponseMessage response) {
        this.response = response;
        return this;
    }

    public FlowContext setMethodParams(Object[] methodParams) {
        this.methodParams = methodParams;
        return this;
    }

    public FlowContext setError(boolean error) {
        this.error = error;
        return this;
    }

    public FlowContext setExecuteActionAfter(boolean executeActionAfter) {
        this.executeActionAfter = executeActionAfter;
        return this;
    }

    @Override
    public Map<FlowOption<?>, Object> getOptions() {
        return this.options;
    }

    @Override
    public BarSkeleton getBarSkeleton() {
        return this.barSkeleton;
    }

    public ActionCommand getActionCommand() {
        return this.actionCommand;
    }

    public Object getActionController() {
        return this.actionController;
    }

    public RequestMessage getRequest() {
        return this.request;
    }

    public ResponseMessage getResponse() {
        return this.response;
    }

    public Object[] getMethodParams() {
        return this.methodParams;
    }

    public Object getMethodResult() {
        return this.methodResult;
    }

    public boolean isError() {
        return this.error;
    }

    public boolean isExecuteActionAfter() {
        return this.executeActionAfter;
    }

    public long getInOutStartTime() {
        return this.inOutStartTime;
    }

    private FlowContext setInOutStartTime(long inOutStartTime) {
        this.inOutStartTime = inOutStartTime;
        return this;
    }

    private FlowContext setInOutTime(long inOutTime) {
        this.inOutTime = inOutTime;
        return this;
    }
}

