/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.core.exception;

import com.iohao.game.action.skeleton.core.exception.ActionErrorEnum;
import com.iohao.game.action.skeleton.core.exception.MsgException;
import com.iohao.game.action.skeleton.core.flow.FlowContext;
import com.iohao.game.action.skeleton.protocol.ResponseMessage;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MsgExceptionKit {
    private static final Logger log = LoggerFactory.getLogger(MsgExceptionKit.class);

    public static void onException(Throwable e, FlowContext flowContext) {
        Objects.requireNonNull(flowContext);
        ResponseMessage response = flowContext.getResponse();
        if (e instanceof MsgException) {
            MsgException msgException = (MsgException)e;
            response.setError(msgException.getMsgExceptionInfo());
        } else {
            response.setError(ActionErrorEnum.systemOtherErrCode);
            log.error(e.getMessage(), e);
        }
        response.setData(null);
        flowContext.broadcastMe(response);
    }

    private MsgExceptionKit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

