/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.core.doc;

import com.iohao.game.action.skeleton.annotation.ActionMethod;
import com.iohao.game.action.skeleton.core.doc.ActionCommandDoc;
import com.iohao.game.common.kit.CollKit;
import com.iohao.game.common.kit.StrKit;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JavaClassDocInfo {
    final JavaClass javaClass;
    Map<String, JavaMethod> javaMethodMap = new HashMap<String, JavaMethod>();

    public JavaClassDocInfo(JavaClass javaClass) {
        this.javaClass = javaClass;
        List methods = javaClass.getMethods();
        for (JavaMethod method : methods) {
            this.javaMethodMap.put(method.toString(), method);
        }
    }

    public ActionCommandDoc createActionCommandDoc(Method method) {
        JavaMethod javaMethod = this.javaMethodMap.get(method.toString());
        int subCmd = method.getAnnotation(ActionMethod.class).value();
        ActionCommandDoc actionCommandDoc = new ActionCommandDoc();
        actionCommandDoc.setSubCmd(subCmd);
        actionCommandDoc.setClassComment(this.javaClass.getComment());
        actionCommandDoc.setClassLineNumber(this.javaClass.getLineNumber());
        actionCommandDoc.setComment(javaMethod.getComment());
        actionCommandDoc.setLineNumber(javaMethod.getLineNumber());
        if (actionCommandDoc.getClassComment() == null) {
            actionCommandDoc.setClassComment("");
        }
        if (actionCommandDoc.getComment() == null) {
            actionCommandDoc.setComment("");
        }
        this.methodParamReturnComment(actionCommandDoc, javaMethod);
        return actionCommandDoc;
    }

    private void methodParamReturnComment(ActionCommandDoc actionCommandDoc, JavaMethod javaMethod) {
        List tags = javaMethod.getTags();
        if (CollKit.isEmpty((Collection)tags)) {
            return;
        }
        for (DocletTag tag : tags) {
            String value = tag.getValue();
            if (StrKit.isEmpty((String)value) || value.contains("flowContext")) continue;
            String name = tag.getName();
            if ("return".equals(name)) {
                actionCommandDoc.setMethodReturnComment(value);
                continue;
            }
            actionCommandDoc.setMethodParamComment(value);
        }
    }

    public String getComment() {
        return this.javaClass.getComment();
    }
}

