/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.core.doc;

import com.iohao.game.action.skeleton.core.ActionCommand;
import com.iohao.game.action.skeleton.core.doc.ActionCommandDoc;
import com.iohao.game.action.skeleton.core.doc.ActionSendDoc;
import com.iohao.game.action.skeleton.core.doc.ActionSendDocsRegion;
import com.iohao.game.action.skeleton.core.flow.parser.MethodParsers;
import com.iohao.game.action.skeleton.protocol.wrapper.ByteValueList;
import com.iohao.game.common.kit.StrKit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class DocInfo {
    String actionSimpleName;
    String classComment;
    ActionSendDocsRegion actionSendDocsRegion;
    final List<Map<String, String>> subBehaviorList = new ArrayList<Map<String, String>>();

    DocInfo() {
    }

    public void setHead(ActionCommand subBehavior) {
        ActionCommandDoc actionCommandDoc = subBehavior.getActionCommandDoc();
        this.actionSimpleName = subBehavior.getActionControllerClazz().getSimpleName();
        this.classComment = actionCommandDoc.getClassComment();
    }

    void add(ActionCommand subBehavior) {
        HashMap<String, String> paramMap = new HashMap<String, String>(16);
        this.subBehaviorList.add(paramMap);
        ActionCommandDoc actionCommandDoc = subBehavior.getActionCommandDoc();
        int cmd = subBehavior.getCmdInfo().getCmd();
        int subCmd = subBehavior.getCmdInfo().getSubCmd();
        ActionCommand.ActionMethodReturnInfo actionMethodReturnInfo = subBehavior.getActionMethodReturnInfo();
        paramMap.put("cmd", String.valueOf(cmd));
        paramMap.put("subCmd", String.valueOf(subCmd));
        paramMap.put("actionSimpleName", subBehavior.getActionControllerClazz().getSimpleName());
        paramMap.put("methodName", subBehavior.getActionMethodName());
        paramMap.put("methodComment", actionCommandDoc.getComment());
        paramMap.put("methodParam", "");
        paramMap.put("returnTypeClazz", this.returnToString(actionMethodReturnInfo));
        paramMap.put("lineNumber", String.valueOf(actionCommandDoc.getLineNumber()));
        Arrays.stream(subBehavior.getParamInfos()).filter(paramInfo -> !paramInfo.isFlowContext()).map(this::paramInfoToString).forEach(methodParam -> paramMap.put("methodParam", (String)methodParam));
        if (subBehavior.isThrowException()) {
            paramMap.put("error", "");
        }
        paramMap.put("methodParamComment", actionCommandDoc.getMethodParamComment());
        paramMap.put("methodReturnComment", actionCommandDoc.getMethodReturnComment());
    }

    private String paramInfoToString(ActionCommand.ParamInfo paramInfo) {
        Class<?> actualClazz = paramInfo.getActualClazz();
        boolean isCustomList = paramInfo.isList() && !MethodParsers.containsKey(actualClazz);
        return this.paramResultInfoToString(actualClazz, isCustomList);
    }

    private String returnToString(ActionCommand.ActionMethodReturnInfo actionMethodReturnInfo) {
        Class<?> actualClazz = actionMethodReturnInfo.getActualClazz();
        boolean isCustomList = actionMethodReturnInfo.isList() && !MethodParsers.containsKey(actualClazz);
        return this.paramResultInfoToString(actualClazz, isCustomList);
    }

    private String paramResultInfoToString(Class<?> actualClazz, boolean isCustomList) {
        if (isCustomList) {
            String simpleName = ByteValueList.class.getSimpleName();
            String simpleNameActualClazz = actualClazz.getSimpleName();
            return String.format("%s<%s>", simpleName, simpleNameActualClazz);
        }
        return actualClazz.getSimpleName();
    }

    String render() {
        if (this.subBehaviorList.isEmpty()) {
            return "";
        }
        String separator = System.lineSeparator();
        ArrayList<String> lineList = new ArrayList<String>();
        String templateHead = "==================== {} {} ====================";
        lineList.add(StrKit.format((CharSequence)templateHead, (Object[])new Object[]{this.actionSimpleName, this.classComment}));
        String subActionCommandTemplate = "\u8def\u7531: {cmd} - {subCmd}  --- \u3010{methodComment}\u3011 --- \u3010{actionSimpleName}:{lineNumber}\u3011\u3010{methodName}\u3011";
        for (Map<String, String> paramMap : this.subBehaviorList) {
            int cmd = Integer.parseInt(paramMap.get("cmd"));
            int subCmd = Integer.parseInt(paramMap.get("subCmd"));
            ActionSendDoc actionSendDoc = this.actionSendDocsRegion.getActionSendDoc(cmd, subCmd);
            String format = StrKit.format((CharSequence)subActionCommandTemplate, paramMap);
            lineList.add(format);
            if (paramMap.containsKey("error")) {
                lineList.add("    \u89e6\u53d1\u5f02\u5e38: (\u65b9\u6cd5\u6709\u53ef\u80fd\u4f1a\u89e6\u53d1\u5f02\u5e38)");
            }
            if (StrKit.isNotEmpty((String)paramMap.get("methodParam"))) {
                format = StrKit.format((CharSequence)"    \u65b9\u6cd5\u53c2\u6570: {methodParam} {methodParamComment}", paramMap);
                lineList.add(format);
            }
            if (StrKit.isNotEmpty((String)paramMap.get("returnTypeClazz"))) {
                format = StrKit.format((CharSequence)"    \u65b9\u6cd5\u8fd4\u56de\u503c: {returnTypeClazz} {methodReturnComment}", paramMap);
                lineList.add(format);
            }
            if (Objects.nonNull(actionSendDoc)) {
                String dataClassName = actionSendDoc.getDataClassName();
                String description = actionSendDoc.getDescription();
                format = StrKit.format((CharSequence)"    \u5e7f\u64ad\u63a8\u9001: {} {}", (Object[])new Object[]{dataClassName, description});
                lineList.add(format);
            }
            lineList.add(" ");
        }
        lineList.add(separator);
        return String.join((CharSequence)separator, lineList);
    }

    public String getActionSimpleName() {
        return this.actionSimpleName;
    }

    public String getClassComment() {
        return this.classComment;
    }

    public ActionSendDocsRegion getActionSendDocsRegion() {
        return this.actionSendDocsRegion;
    }

    public List<Map<String, String>> getSubBehaviorList() {
        return this.subBehaviorList;
    }
}

