/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.core.doc;

import com.iohao.game.action.skeleton.core.CmdInfo;
import com.iohao.game.action.skeleton.core.doc.ActionSendDoc;
import com.iohao.game.action.skeleton.protocol.wrapper.ByteValueList;
import com.iohao.game.action.skeleton.protocol.wrapper.WrapperKit;
import java.util.Objects;
import java.util.Optional;

public final class BroadcastDocBuilder {
    final CmdInfo cmdInfo;
    String description;
    String dataClassName;

    BroadcastDocBuilder(CmdInfo cmdInfo) {
        this.cmdInfo = cmdInfo;
    }

    public BroadcastDocBuilder setDataClassList(Class<?> dataClass) {
        String simpleName = ByteValueList.class.getSimpleName();
        String simpleNameActualClazz = dataClass.getSimpleName();
        this.dataClassName = String.format("%s<%s>", simpleName, simpleNameActualClazz);
        return this;
    }

    public BroadcastDocBuilder setDataClass(Class<?> dataClass) {
        this.dataClassName = WrapperKit.optionalRefType(dataClass).map(Class::getSimpleName).orElse(dataClass.getSimpleName());
        return this;
    }

    public ActionSendDoc build() {
        Objects.requireNonNull(this.description);
        this.dataClassName = Optional.ofNullable(this.dataClassName).orElse("none");
        ActionSendDoc actionSendDoc = new ActionSendDoc(this.cmdInfo);
        actionSendDoc.setDescription(this.description);
        actionSendDoc.setDataClassName(this.dataClassName);
        return actionSendDoc;
    }

    public BroadcastDocBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    private BroadcastDocBuilder setDataClassName(String dataClassName) {
        this.dataClassName = dataClassName;
        return this;
    }
}

