/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.core.doc;

import com.iohao.game.action.skeleton.core.ActionCommand;
import com.iohao.game.action.skeleton.core.BarSkeleton;
import com.iohao.game.action.skeleton.core.CmdInfo;
import com.iohao.game.action.skeleton.core.DevConfig;
import com.iohao.game.action.skeleton.core.doc.ActionCommandDoc;
import com.iohao.game.action.skeleton.core.doc.ActionDocs;
import com.iohao.game.action.skeleton.core.doc.ActionSendDoc;
import com.iohao.game.action.skeleton.core.doc.ActionSendDocsRegion;
import com.iohao.game.action.skeleton.core.doc.DocInfo;
import com.iohao.game.action.skeleton.core.doc.ErrorCodeDoc;
import com.iohao.game.action.skeleton.core.doc.ErrorCodeDocsRegion;
import com.iohao.game.common.kit.StrKit;
import com.iohao.game.common.kit.io.FileKit;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class BarSkeletonDoc {
    final List<BarSkeleton> skeletonList = new LinkedList<BarSkeleton>();
    String docFileName = "doc_game.txt";
    String docPath;
    boolean generateDoc = true;

    public void setGenerateDoc(boolean generateDoc) {
        if (this.generateDoc) {
            this.generateDoc = generateDoc;
        }
    }

    public void addSkeleton(BarSkeleton barSkeleton) {
        this.skeletonList.add(barSkeleton);
    }

    public void buildDoc() {
        if (!this.generateDoc) {
            return;
        }
        if (Objects.isNull(this.docPath)) {
            this.docPath = System.getProperty("user.dir") + File.separator + this.docFileName;
        }
        this.buildDoc(this.docPath);
    }

    public void buildDoc(String docPath) {
        Objects.requireNonNull(docPath);
        if (FileKit.isDirectory((String)docPath)) {
            throw new RuntimeException("file is Directory ");
        }
        this.cmdDataClassRegionDevInfo();
        ActionSendDocsRegion actionSendDocsRegion = this.createActionSendDocsRegion();
        ArrayList<String> docContentList = new ArrayList<String>(128);
        this.gameDocURLDescription(docContentList);
        ActionDocs.stream().forEach(actionDoc -> {
            DocInfo docInfo = new DocInfo();
            docInfo.actionSendDocsRegion = actionSendDocsRegion;
            actionDoc.stream().map(ActionCommandDoc::getActionCommand).filter(Objects::nonNull).forEach(subBehavior -> {
                docInfo.setHead((ActionCommand)subBehavior);
                docInfo.add((ActionCommand)subBehavior);
            });
            String render = docInfo.render();
            docContentList.add(render);
        });
        this.extractedActionSend(actionSendDocsRegion, docContentList);
        this.extractedErrorCode(docContentList);
        String docText = String.join((CharSequence)"", docContentList);
        FileKit.writeUtf8String((String)docText, (String)docPath);
    }

    public List<BarSkeleton> listBarSkeleton() {
        return new ArrayList<BarSkeleton>(this.skeletonList);
    }

    private void gameDocURLDescription(List<String> docContentList) {
        String gameDocInfo = "==================== \u6e38\u620f\u6587\u6863\u683c\u5f0f\u8bf4\u660e ====================\nhttps://www.yuque.com/iohao/game/irth38#cJLdC\n\n";
        docContentList.add(gameDocInfo);
    }

    private void extractedErrorCode(List<String> docContentList) {
        ErrorCodeDocsRegion errorCodeDocsRegion = this.createErrorCodeDocsRegion();
        String separator = System.lineSeparator();
        docContentList.add("==================== \u9519\u8bef\u7801 ====================");
        docContentList.add(separator);
        for (ErrorCodeDoc errorCodeDoc : errorCodeDocsRegion.listErrorCodeDoc()) {
            String template = " {} : {} ";
            String format = StrKit.format((CharSequence)template, (Object[])new Object[]{errorCodeDoc.getCode(), errorCodeDoc.getMsg()});
            docContentList.add(format);
            docContentList.add(separator);
        }
    }

    private void extractedActionSend(ActionSendDocsRegion actionSendDocsRegion, List<String> docContentList) {
        List<ActionSendDoc> actionSendDocList = actionSendDocsRegion.listActionSendDoc();
        if (actionSendDocList.isEmpty()) {
            return;
        }
        String separator = System.lineSeparator();
        docContentList.add("==================== \u5176\u5b83\u5e7f\u64ad\u63a8\u9001 ====================");
        docContentList.add(separator);
        for (ActionSendDoc actionSendDoc : actionSendDocList) {
            String template = "\u8def\u7531: {cmd} - {subCmd}  --- \u5e7f\u64ad\u63a8\u9001: {dataClass}";
            if (StrKit.isNotEmpty((String)actionSendDoc.getDescription())) {
                template = "\u8def\u7531: {cmd} - {subCmd}  --- \u5e7f\u64ad\u63a8\u9001: {dataClass} ({description})";
            }
            HashMap<String, Object> stringObjectMap = new HashMap<String, Object>();
            stringObjectMap.put("cmd", actionSendDoc.getCmd());
            stringObjectMap.put("subCmd", actionSendDoc.getSubCmd());
            stringObjectMap.put("dataClass", actionSendDoc.getDataClassName());
            stringObjectMap.put("description", actionSendDoc.getDescription());
            String format = StrKit.format((CharSequence)template, stringObjectMap);
            docContentList.add(format);
            docContentList.add(separator);
        }
    }

    private ActionSendDocsRegion createActionSendDocsRegion() {
        ActionSendDocsRegion actionSendDocsRegion = new ActionSendDocsRegion();
        this.skeletonList.stream().map(BarSkeleton::getActionSendDocs).forEach(actionSendDocsRegion::addActionSendDocs);
        return actionSendDocsRegion;
    }

    private ErrorCodeDocsRegion createErrorCodeDocsRegion() {
        ErrorCodeDocsRegion region = new ErrorCodeDocsRegion();
        this.skeletonList.stream().map(BarSkeleton::getErrorCodeDocs).forEach(region::addErrorCodeDocs);
        return region;
    }

    private void cmdDataClassRegionDevInfo() {
        this.skeletonList.stream().map(BarSkeleton::getActionCommandRegions).flatMap(actionCommandRegions -> actionCommandRegions.getRegionMap().values().stream()).flatMap(actionCommandRegion -> actionCommandRegion.values().stream()).forEach(actionCommand -> {
            CmdInfo cmdInfo = actionCommand.getCmdInfo();
            ActionCommand.ActionMethodReturnInfo actionMethodReturnInfo = actionCommand.getActionMethodReturnInfo();
            Class<?> dataClass = actionMethodReturnInfo.getActualTypeArgumentClazz();
            DevConfig.put(cmdInfo.getCmdMerge(), dataClass);
        });
    }

    private BarSkeletonDoc() {
    }

    public static BarSkeletonDoc me() {
        return Holder.ME;
    }

    public void setDocFileName(String docFileName) {
        this.docFileName = docFileName;
    }

    public void setDocPath(String docPath) {
        this.docPath = docPath;
    }

    private static class Holder {
        static final BarSkeletonDoc ME = new BarSkeletonDoc();

        private Holder() {
        }
    }
}

