/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.core.doc;

import com.iohao.game.action.skeleton.core.ActionCommand;
import com.iohao.game.action.skeleton.core.CmdInfo;
import com.iohao.game.action.skeleton.core.doc.ActionCommandDoc;
import com.iohao.game.action.skeleton.core.doc.JavaClassDocInfo;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.jctools.maps.NonBlockingHashMap;

public class ActionDoc {
    private final int cmd;
    private final Class<?> controllerClazz;
    private final Map<Integer, ActionCommandDoc> actionCommandDocMap = new NonBlockingHashMap();
    private JavaClassDocInfo javaClassDocInfo;

    public ActionDoc(int cmd, Class<?> controllerClazz) {
        this.cmd = cmd;
        this.controllerClazz = controllerClazz;
    }

    public void addActionCommandDoc(ActionCommandDoc actionCommandDoc) {
        int subCmd = actionCommandDoc.getSubCmd();
        this.actionCommandDocMap.put(subCmd, actionCommandDoc);
    }

    public void addActionCommand(ActionCommand actionCommand) {
        CmdInfo cmdInfo = actionCommand.getCmdInfo();
        int subCmd = cmdInfo.getSubCmd();
        if (this.actionCommandDocMap.containsKey(subCmd)) {
            ActionCommandDoc actionCommandDoc = this.actionCommandDocMap.get(subCmd);
            actionCommandDoc.setActionCommand(actionCommand);
        }
    }

    Stream<ActionCommandDoc> stream() {
        return this.actionCommandDocMap.values().stream().sorted(Comparator.comparingInt(ActionCommandDoc::getSubCmd));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActionDoc)) {
            return false;
        }
        ActionDoc that = (ActionDoc)o;
        return this.cmd == that.cmd && Objects.equals(this.controllerClazz, that.controllerClazz);
    }

    public int hashCode() {
        return Objects.hash(this.cmd, this.controllerClazz);
    }

    public int getCmd() {
        return this.cmd;
    }

    public Class<?> getControllerClazz() {
        return this.controllerClazz;
    }

    public Map<Integer, ActionCommandDoc> getActionCommandDocMap() {
        return this.actionCommandDocMap;
    }

    public JavaClassDocInfo getJavaClassDocInfo() {
        return this.javaClassDocInfo;
    }

    public void setJavaClassDocInfo(JavaClassDocInfo javaClassDocInfo) {
        this.javaClassDocInfo = javaClassDocInfo;
    }
}

