/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.core.doc;

import com.iohao.game.action.skeleton.core.doc.JavaClassDocInfo;
import com.iohao.game.common.kit.ClassScanner;
import com.iohao.game.common.kit.io.FileKit;
import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ActionCommandDocKit {
    private static final Logger log = LoggerFactory.getLogger((String)"CommonStdout");
    static Function<URL, String> sourceFilePathFun = resourceUrl -> {
        String path = resourceUrl.getPath();
        return path.contains("target/classes") ? path.replace("target/classes", "src/main/java") : path.replace("build/classes", "src/main/java");
    };

    public static Map<String, JavaClassDocInfo> getJavaClassDocInfoMap(List<Class<?>> controllerList) {
        JavaProjectBuilder javaProjectBuilder = new JavaProjectBuilder();
        HashMap<String, JavaClassDocInfo> javaClassDocInfoMap = new HashMap<String, JavaClassDocInfo>(controllerList.size());
        for (Class<?> actionClazz : controllerList) {
            try {
                String packagePath = actionClazz.getPackageName();
                ClassScanner classScanner = new ClassScanner(packagePath, null);
                List resources = classScanner.listResource();
                for (URL resource : resources) {
                    String srcPath = sourceFilePathFun.apply(resource);
                    File file = new File(srcPath);
                    if (!FileKit.exist((File)file)) continue;
                    javaProjectBuilder.addSourceTree(file);
                }
                Collection classes = javaProjectBuilder.getClasses();
                for (JavaClass javaClass : classes) {
                    JavaClassDocInfo javaClassDocInfo = new JavaClassDocInfo(javaClass);
                    javaClassDocInfoMap.put(javaClass.toString(), javaClassDocInfo);
                }
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return javaClassDocInfoMap;
    }

    private ActionCommandDocKit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static void setSourceFilePathFun(Function<URL, String> sourceFilePathFun) {
        ActionCommandDocKit.sourceFilePathFun = sourceFilePathFun;
    }
}

