/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.core.action.parser;

import com.baidu.bjf.remoting.protobuf.annotation.ProtobufClass;
import com.iohao.game.action.skeleton.core.BarSkeleton;
import com.iohao.game.action.skeleton.core.action.parser.ActionParserContext;
import com.iohao.game.action.skeleton.core.action.parser.ActionParserListener;
import com.iohao.game.action.skeleton.core.action.parser.ProtobufActionParserListener;
import java.util.Set;
import java.util.function.Predicate;
import org.jctools.maps.NonBlockingHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProtobufCheckActionParserListener
implements ActionParserListener {
    private static final Logger log = LoggerFactory.getLogger(ProtobufCheckActionParserListener.class);
    final Set<Class<?>> protoSet = new NonBlockingHashSet();

    @Override
    public void onActionCommand(ActionParserContext context) {
        Predicate<Class<?>> protobufClassPredicate = c -> c.getAnnotation(ProtobufClass.class) == null;
        ProtobufActionParserListener.collect(context, protobufClassPredicate, this.protoSet);
    }

    @Override
    public void onAfter(BarSkeleton barSkeleton) {
        if (this.protoSet.isEmpty()) {
            return;
        }
        log.error("======== \u6ce8\u610f\uff0c\u534f\u8bae\u7c7b\u6ca1\u6709\u6dfb\u52a0 ProtobufClass \u6ce8\u89e3 ========");
        for (Class<?> protoClass : this.protoSet) {
            log.error(protoClass.toString());
        }
    }

    private ProtobufCheckActionParserListener() {
    }

    public static ProtobufCheckActionParserListener me() {
        return Holder.ME;
    }

    private static class Holder {
        static final ProtobufCheckActionParserListener ME = new ProtobufCheckActionParserListener();

        private Holder() {
        }
    }
}

