/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.core.action.parser;

import com.baidu.bjf.remoting.protobuf.annotation.ProtobufClass;
import com.iohao.game.action.skeleton.core.ActionCommand;
import com.iohao.game.action.skeleton.core.BarSkeleton;
import com.iohao.game.action.skeleton.core.action.parser.ActionParserContext;
import com.iohao.game.action.skeleton.core.action.parser.ActionParserListener;
import com.iohao.game.action.skeleton.protocol.wrapper.BoolValue;
import com.iohao.game.action.skeleton.protocol.wrapper.BoolValueList;
import com.iohao.game.action.skeleton.protocol.wrapper.ByteValueList;
import com.iohao.game.action.skeleton.protocol.wrapper.IntValue;
import com.iohao.game.action.skeleton.protocol.wrapper.IntValueList;
import com.iohao.game.action.skeleton.protocol.wrapper.LongValue;
import com.iohao.game.action.skeleton.protocol.wrapper.LongValueList;
import com.iohao.game.action.skeleton.protocol.wrapper.StringValue;
import com.iohao.game.action.skeleton.protocol.wrapper.StringValueList;
import com.iohao.game.action.skeleton.protocol.wrapper.WrapperKit;
import com.iohao.game.common.kit.ProtoKit;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.jctools.maps.NonBlockingHashSet;

public final class ProtobufActionParserListener
implements ActionParserListener {
    private final Set<Class<?>> protoSet = new NonBlockingHashSet();

    @Override
    public void onActionCommand(ActionParserContext context) {
        Predicate<Class<?>> protobufClassPredicate = c -> Objects.nonNull(c.getAnnotation(ProtobufClass.class));
        ProtobufActionParserListener.collect(context, protobufClassPredicate, this.protoSet);
    }

    static void collect(ActionParserContext context, Predicate<Class<?>> protobufClassPredicate, Set<Class<?>> protoSet) {
        ActionCommand actionCommand = context.getActionCommand();
        actionCommand.streamParamInfo().filter(ActionCommand.ParamInfo::isBizData).map(ActionCommand.ParamInfo::getActualTypeArgumentClazz).filter(clazz -> !WrapperKit.isWrapper(clazz)).filter(protobufClassPredicate).forEach(protoSet::add);
        Optional.ofNullable(actionCommand.getActionMethodReturnInfo()).filter(actionMethodReturnInfo -> !actionMethodReturnInfo.isVoid()).map(ActionCommand.ActionMethodReturnInfo::getActualTypeArgumentClazz).filter(clazz -> !WrapperKit.isWrapper(clazz)).filter(protobufClassPredicate).ifPresent(protoSet::add);
    }

    @Override
    public void onAfter(BarSkeleton barSkeleton) {
        this.protoSet.forEach(ProtoKit::create);
    }

    private ProtobufActionParserListener() {
        ProtoKit.create(ByteValueList.class);
        ProtoKit.create(IntValue.class);
        ProtoKit.create(IntValueList.class);
        ProtoKit.create(BoolValue.class);
        ProtoKit.create(BoolValueList.class);
        ProtoKit.create(LongValue.class);
        ProtoKit.create(LongValueList.class);
        ProtoKit.create(StringValue.class);
        ProtoKit.create(StringValueList.class);
    }

    public static ProtobufActionParserListener me() {
        return Holder.ME;
    }

    private static class Holder {
        static final ProtobufActionParserListener ME = new ProtobufActionParserListener();

        private Holder() {
        }
    }
}

