/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.core;

import com.iohao.game.action.skeleton.IoGameVersion;
import com.iohao.game.action.skeleton.core.ActionCommand;
import com.iohao.game.action.skeleton.core.BarSkeleton;
import com.iohao.game.action.skeleton.core.BarSkeletonSetting;
import com.iohao.game.action.skeleton.core.DataCodecKit;
import com.iohao.game.action.skeleton.core.Handler;
import com.iohao.game.action.skeleton.core.codec.DataCodec;
import com.iohao.game.action.skeleton.core.flow.ActionMethodInOut;
import com.iohao.game.action.skeleton.core.runner.Runners;
import com.iohao.game.common.kit.ArrayKit;
import com.iohao.game.common.kit.StrKit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.fusesource.jansi.Ansi;

final class PrintActionKit {
    static void print(BarSkeleton barSkeleton, BarSkeletonSetting setting) {
        List<Object> list;
        if (!setting.print) {
            return;
        }
        if (setting.isPrintHandler()) {
            list = List.of(barSkeleton.getHandlers());
            PrintActionKit.printHandler(list);
        }
        if (setting.isPrintInout()) {
            list = barSkeleton.inOutManager.listInOut();
            PrintActionKit.printInout(list);
        }
        if (setting.isPrintDataCodec()) {
            PrintActionKit.printDataCodec();
        }
        if (setting.isPrintRunners()) {
            PrintActionKit.extractedRunners(barSkeleton);
        }
        if (setting.isPrintAction()) {
            PrintActionKit.printActionCommand(barSkeleton.actionCommandRegions.actionCommands, setting.printActionShort);
        }
        System.out.println();
    }

    private static void extractedRunners(BarSkeleton barSkeleton) {
        Runners runners = barSkeleton.runners;
        List<String> nameList = runners.listRunnerName();
        String title = "@|CYAN ======================== Runners ========================= |@";
        System.out.println(Ansi.ansi().render(title));
        System.out.println("\u5982\u679c\u9700\u8981\u5173\u95ed\u6253\u5370, \u67e5\u770b BarSkeletonBuilder#setting#printRunners");
        for (String name : nameList) {
            String info = String.format("@|BLUE %s |@", name);
            System.out.println(Ansi.ansi().render(info));
        }
    }

    static void printInout(List<ActionMethodInOut> inOuts) {
        String title = "@|CYAN ======================== InOut ========================= |@";
        System.out.println(Ansi.ansi().render(title));
        System.out.println("\u5982\u679c\u9700\u8981\u5173\u95ed\u6253\u5370, \u67e5\u770b BarSkeletonBuilder#setting#printInout");
        for (ActionMethodInOut inOut : inOuts) {
            String info = String.format("@|BLUE %s |@", inOut.getClass());
            System.out.println(Ansi.ansi().render(info));
        }
    }

    static void printHandler(List<Handler> handlers) {
        String iohaoTitle = "@|CYAN ======================== \u4e1a\u52a1\u6846\u67b6 iohao ========================= |@";
        System.out.println(Ansi.ansi().render(iohaoTitle));
        System.out.println(IoGameVersion.VERSION);
        String colorStr = "@|BLACK BLACK|@ @|RED RED|@ @|GREEN GREEN|@ @|YELLOW YELLOW|@ @|BLUE BLUE|@ @|MAGENTA MAGENTA|@ @|CYAN CYAN|@ @|WHITE WHITE|@ @|DEFAULT DEFAULT|@";
        System.out.println(Ansi.ansi().render(colorStr));
        String title = "@|CYAN ======================== Handler ========================= |@";
        System.out.println(Ansi.ansi().render(title));
        System.out.println("\u5982\u679c\u9700\u8981\u5173\u95ed\u6253\u5370, \u67e5\u770b BarSkeletonBuilder#setting#printHandler");
        for (Handler handler : handlers) {
            String info = String.format("@|BLUE %s |@", handler.getClass());
            System.out.println(Ansi.ansi().render(info));
        }
    }

    static void printActionCommand(ActionCommand[][] behaviors, boolean shortName) {
        String title = "@|CYAN ======================== action ========================= |@";
        System.out.println(Ansi.ansi().render(title));
        String tip = "\u5982\u679c\u9700\u8981\u5173\u95ed\u6253\u5370, \u67e5\u770b BarSkeletonBuilder#setting#printAction;\n\u5982\u9700\u8981\u6253\u5370\uff08class method params return\uff09\u5b8c\u6574\u7684\u5305\u540d, \u67e5\u770b BarSkeletonBuilder#setting#printActionShort;\n";
        System.out.print(tip);
        for (int cmd = 0; cmd < behaviors.length; ++cmd) {
            ActionCommand[] subBehaviors = behaviors[cmd];
            if (Objects.isNull(subBehaviors)) continue;
            for (int subCmd = 0; subCmd < subBehaviors.length; ++subCmd) {
                ActionCommand subBehavior = subBehaviors[subCmd];
                if (Objects.isNull(subBehavior)) continue;
                Object[] paramInfos = subBehavior.getParamInfos();
                String paramInfo = "";
                String paramInfoShort = "";
                if (ArrayKit.notEmpty((Object[])paramInfos)) {
                    paramInfoShort = ArrayKit.join((Object[])paramInfos, (CharSequence)", ");
                    paramInfo = Arrays.stream(paramInfos).map(theParamInfo -> theParamInfo.toString(true)).collect(Collectors.joining(", "));
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("cmd", cmd);
                params.put("subCmd", subCmd);
                params.put("actionName", subBehavior.getActionControllerClazz().getName());
                params.put("methodName", subBehavior.getActionMethodName());
                params.put("paramInfo", paramInfo);
                params.put("paramInfoShort", paramInfoShort);
                params.put("actionNameShort", subBehavior.getActionControllerClazz().getSimpleName());
                params.put("throw", subBehavior.isThrowException() ? "throws" : "");
                PrintActionKit.shortName(params, shortName);
                ActionCommand.ActionMethodReturnInfo actionMethodReturnInfo = subBehavior.getActionMethodReturnInfo();
                params.put("returnTypeClazz", actionMethodReturnInfo.toString());
                params.put("returnTypeClazzShort", actionMethodReturnInfo.toString(false));
                PrintActionKit.checkReturnType(actionMethodReturnInfo.getReturnTypeClazz());
                PrintActionKit.shortName(params, shortName);
                params.put("actionSimpleName", subBehavior.getActionControllerClazz().getSimpleName());
                params.put("lineNumber", subBehavior.actionCommandDoc.getLineNumber());
                String routeCell = Color.red.format("\u8def\u7531: {cmd} - {subCmd}", params);
                String actionCell = Color.white.wrap("--- action :");
                String actionNameCell = Color.blue.format("{actionName}", params);
                String methodNameCell = Color.blue.format("{methodName}", params);
                String paramInfoCell = Color.green.format("{paramInfo}", params);
                String returnCell = Color.defaults.wrap("return");
                String returnValueCell = Color.magenta.format("{returnTypeClazz}", params);
                String throwCell = Color.red.format("{throw}", params);
                params.put("routeCell", routeCell);
                params.put("actionCell", actionCell);
                params.put("actionNameCell", actionNameCell);
                params.put("methodNameCell", methodNameCell);
                params.put("returnCell", returnCell);
                params.put("returnValueCell", returnValueCell);
                params.put("throwCell", throwCell);
                params.put("paramInfoCell", paramInfoCell);
                String lineTemplate = "{routeCell} {actionCell} {actionNameCell}.{methodNameCell}({paramInfoCell}) {throwCell} --- return {returnValueCell}  ~~~ see.({actionSimpleName}.java:{lineNumber})";
                String text = StrKit.format((CharSequence)lineTemplate, params);
                System.out.println(Ansi.ansi().render(text));
            }
        }
    }

    static void printDataCodec() {
        DataCodec dataCodec = DataCodecKit.dataCodec;
        String title = "@|CYAN ======================== \u5f53\u524d\u4f7f\u7528\u7684\u7f16\u89e3\u7801\u5668 ========================= |@";
        System.out.println(Ansi.ansi().render(title));
        System.out.println("\u5982\u679c\u9700\u8981\u5173\u95ed\u6253\u5370, \u67e5\u770b BarSkeletonBuilder#setting#printDataCodec");
        String info = String.format("@|BLUE %s - %s |@", dataCodec.codecName(), dataCodec.getClass().getName());
        System.out.println(Ansi.ansi().render(info));
    }

    private static void shortName(Map<String, Object> params, boolean shortName) {
        if (!shortName) {
            return;
        }
        params.put("paramInfo", params.get("paramInfoShort"));
        params.put("actionName", params.get("actionNameShort"));
        params.put("returnTypeClazz", params.get("returnTypeClazzShort"));
        params.put("actualTypeArgumentClazz", params.get("actualTypeArgumentClazzShort"));
    }

    private static void checkReturnType(Class<?> returnTypeClazz) {
        if (Set.class.isAssignableFrom(returnTypeClazz) || Map.class.isAssignableFrom(returnTypeClazz)) {
            throw new RuntimeException("action \u8fd4\u56de\u503c\u548c\u53c2\u6570\u4e0d\u652f\u6301 set\u3001map \u548c \u57fa\u7840\u7c7b\u578b!");
        }
    }

    private PrintActionKit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class Color {
        String start;
        static final Color red = new Color("@|red");
        static final Color white = new Color("@|white");
        static final Color blue = new Color("@|blue");
        static final Color green = new Color("@|green");
        static final Color defaults = new Color("@|default");
        static final Color magenta = new Color("@|magenta");

        public Color(String start) {
            this.start = start;
        }

        String wrap(String str) {
            return this.start + " " + str + "|@";
        }

        String format(String template, Map<String, Object> params) {
            String str = StrKit.format((CharSequence)template, params);
            str = this.wrap(str);
            return str;
        }
    }
}

